<?php namespace HL7\FHIR\STU3;

/*!
 * This class was generated with the PHPFHIR library (https://github.com/dcarbone/php-fhir) using
 * class definitions from HL7 FHIR (https://www.hl7.org/fhir/)
 * 
 * Class creation date: February 10th, 2018
 * 
 * PHPFHIR Copyright:
 * 
 * Copyright 2016-2017 Daniel Carbone (daniel.p.carbone@gmail.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

class PHPFHIRParserMap implements \ArrayAccess, \Iterator
{
    /** @var array */
    private $_bigDumbMap = array (
    'date' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'date-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'dateTime' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'dateTime-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'code' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'code-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'string' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'integer' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'integer-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'oid' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'oid-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'uri' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'uri-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'uuid' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUuid',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'uuid-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'instant' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'instant-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'boolean' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'boolean-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'base64Binary' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'base64Binary-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'unsignedInt' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'unsignedInt-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'markdown' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'markdown-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'time' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'time-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'id' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'id-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'positiveInt' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'positiveInt-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'decimal' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'ResourceContainer' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResourceContainer',
    'extendedElementName' => null,
    'properties' =>
    array (
      'Account' =>
      array (
        'setter' => 'setAccount',
        'element' => 'Account',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAccount',
      ),
      'ActivityDefinition' =>
      array (
        'setter' => 'setActivityDefinition',
        'element' => 'ActivityDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRActivityDefinition',
      ),
      'AdverseEvent' =>
      array (
        'setter' => 'setAdverseEvent',
        'element' => 'AdverseEvent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAdverseEvent',
      ),
      'AllergyIntolerance' =>
      array (
        'setter' => 'setAllergyIntolerance',
        'element' => 'AllergyIntolerance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAllergyIntolerance',
      ),
      'Appointment' =>
      array (
        'setter' => 'setAppointment',
        'element' => 'Appointment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAppointment',
      ),
      'AppointmentResponse' =>
      array (
        'setter' => 'setAppointmentResponse',
        'element' => 'AppointmentResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAppointmentResponse',
      ),
      'AuditEvent' =>
      array (
        'setter' => 'setAuditEvent',
        'element' => 'AuditEvent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAuditEvent',
      ),
      'Basic' =>
      array (
        'setter' => 'setBasic',
        'element' => 'Basic',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRBasic',
      ),
      'Binary' =>
      array (
        'setter' => 'setBinary',
        'element' => 'Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBinary',
      ),
      'BodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'BodySite',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRBodySite',
      ),
      'Bundle' =>
      array (
        'setter' => 'setBundle',
        'element' => 'Bundle',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle',
      ),
      'CapabilityStatement' =>
      array (
        'setter' => 'setCapabilityStatement',
        'element' => 'CapabilityStatement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCapabilityStatement',
      ),
      'CarePlan' =>
      array (
        'setter' => 'setCarePlan',
        'element' => 'CarePlan',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCarePlan',
      ),
      'CareTeam' =>
      array (
        'setter' => 'setCareTeam',
        'element' => 'CareTeam',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCareTeam',
      ),
      'ChargeItem' =>
      array (
        'setter' => 'setChargeItem',
        'element' => 'ChargeItem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRChargeItem',
      ),
      'Claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Claim',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClaim',
      ),
      'ClaimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'ClaimResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClaimResponse',
      ),
      'ClinicalImpression' =>
      array (
        'setter' => 'setClinicalImpression',
        'element' => 'ClinicalImpression',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClinicalImpression',
      ),
      'CodeSystem' =>
      array (
        'setter' => 'setCodeSystem',
        'element' => 'CodeSystem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCodeSystem',
      ),
      'Communication' =>
      array (
        'setter' => 'setCommunication',
        'element' => 'Communication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCommunication',
      ),
      'CommunicationRequest' =>
      array (
        'setter' => 'setCommunicationRequest',
        'element' => 'CommunicationRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCommunicationRequest',
      ),
      'CompartmentDefinition' =>
      array (
        'setter' => 'setCompartmentDefinition',
        'element' => 'CompartmentDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCompartmentDefinition',
      ),
      'Composition' =>
      array (
        'setter' => 'setComposition',
        'element' => 'Composition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRComposition',
      ),
      'ConceptMap' =>
      array (
        'setter' => 'setConceptMap',
        'element' => 'ConceptMap',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRConceptMap',
      ),
      'Condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Condition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCondition',
      ),
      'Consent' =>
      array (
        'setter' => 'setConsent',
        'element' => 'Consent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRConsent',
      ),
      'Contract' =>
      array (
        'setter' => 'setContract',
        'element' => 'Contract',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRContract',
      ),
      'Coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Coverage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCoverage',
      ),
      'DataElement' =>
      array (
        'setter' => 'setDataElement',
        'element' => 'DataElement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDataElement',
      ),
      'DetectedIssue' =>
      array (
        'setter' => 'setDetectedIssue',
        'element' => 'DetectedIssue',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDetectedIssue',
      ),
      'Device' =>
      array (
        'setter' => 'setDevice',
        'element' => 'Device',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDevice',
      ),
      'DeviceComponent' =>
      array (
        'setter' => 'setDeviceComponent',
        'element' => 'DeviceComponent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceComponent',
      ),
      'DeviceMetric' =>
      array (
        'setter' => 'setDeviceMetric',
        'element' => 'DeviceMetric',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceMetric',
      ),
      'DeviceRequest' =>
      array (
        'setter' => 'setDeviceRequest',
        'element' => 'DeviceRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceRequest',
      ),
      'DeviceUseStatement' =>
      array (
        'setter' => 'setDeviceUseStatement',
        'element' => 'DeviceUseStatement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceUseStatement',
      ),
      'DiagnosticReport' =>
      array (
        'setter' => 'setDiagnosticReport',
        'element' => 'DiagnosticReport',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDiagnosticReport',
      ),
      'DocumentManifest' =>
      array (
        'setter' => 'setDocumentManifest',
        'element' => 'DocumentManifest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDocumentManifest',
      ),
      'DocumentReference' =>
      array (
        'setter' => 'setDocumentReference',
        'element' => 'DocumentReference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDocumentReference',
      ),
      'EligibilityRequest' =>
      array (
        'setter' => 'setEligibilityRequest',
        'element' => 'EligibilityRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREligibilityRequest',
      ),
      'EligibilityResponse' =>
      array (
        'setter' => 'setEligibilityResponse',
        'element' => 'EligibilityResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREligibilityResponse',
      ),
      'Encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Encounter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREncounter',
      ),
      'Endpoint' =>
      array (
        'setter' => 'setEndpoint',
        'element' => 'Endpoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREndpoint',
      ),
      'EnrollmentRequest' =>
      array (
        'setter' => 'setEnrollmentRequest',
        'element' => 'EnrollmentRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREnrollmentRequest',
      ),
      'EnrollmentResponse' =>
      array (
        'setter' => 'setEnrollmentResponse',
        'element' => 'EnrollmentResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREnrollmentResponse',
      ),
      'EpisodeOfCare' =>
      array (
        'setter' => 'setEpisodeOfCare',
        'element' => 'EpisodeOfCare',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREpisodeOfCare',
      ),
      'ExpansionProfile' =>
      array (
        'setter' => 'setExpansionProfile',
        'element' => 'ExpansionProfile',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRExpansionProfile',
      ),
      'ExplanationOfBenefit' =>
      array (
        'setter' => 'setExplanationOfBenefit',
        'element' => 'ExplanationOfBenefit',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRExplanationOfBenefit',
      ),
      'FamilyMemberHistory' =>
      array (
        'setter' => 'setFamilyMemberHistory',
        'element' => 'FamilyMemberHistory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRFamilyMemberHistory',
      ),
      'Flag' =>
      array (
        'setter' => 'setFlag',
        'element' => 'Flag',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRFlag',
      ),
      'Goal' =>
      array (
        'setter' => 'setGoal',
        'element' => 'Goal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGoal',
      ),
      'GraphDefinition' =>
      array (
        'setter' => 'setGraphDefinition',
        'element' => 'GraphDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGraphDefinition',
      ),
      'Group' =>
      array (
        'setter' => 'setGroup',
        'element' => 'Group',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGroup',
      ),
      'GuidanceResponse' =>
      array (
        'setter' => 'setGuidanceResponse',
        'element' => 'GuidanceResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGuidanceResponse',
      ),
      'HealthcareService' =>
      array (
        'setter' => 'setHealthcareService',
        'element' => 'HealthcareService',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRHealthcareService',
      ),
      'ImagingManifest' =>
      array (
        'setter' => 'setImagingManifest',
        'element' => 'ImagingManifest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImagingManifest',
      ),
      'ImagingStudy' =>
      array (
        'setter' => 'setImagingStudy',
        'element' => 'ImagingStudy',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImagingStudy',
      ),
      'Immunization' =>
      array (
        'setter' => 'setImmunization',
        'element' => 'Immunization',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImmunization',
      ),
      'ImmunizationRecommendation' =>
      array (
        'setter' => 'setImmunizationRecommendation',
        'element' => 'ImmunizationRecommendation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImmunizationRecommendation',
      ),
      'ImplementationGuide' =>
      array (
        'setter' => 'setImplementationGuide',
        'element' => 'ImplementationGuide',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImplementationGuide',
      ),
      'Library' =>
      array (
        'setter' => 'setLibrary',
        'element' => 'Library',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLibrary',
      ),
      'Linkage' =>
      array (
        'setter' => 'setLinkage',
        'element' => 'Linkage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLinkage',
      ),
      'List' =>
      array (
        'setter' => 'setList',
        'element' => 'List',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRList',
      ),
      'Location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Location',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLocation',
      ),
      'Measure' =>
      array (
        'setter' => 'setMeasure',
        'element' => 'Measure',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMeasure',
      ),
      'MeasureReport' =>
      array (
        'setter' => 'setMeasureReport',
        'element' => 'MeasureReport',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMeasureReport',
      ),
      'Media' =>
      array (
        'setter' => 'setMedia',
        'element' => 'Media',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedia',
      ),
      'Medication' =>
      array (
        'setter' => 'setMedication',
        'element' => 'Medication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedication',
      ),
      'MedicationAdministration' =>
      array (
        'setter' => 'setMedicationAdministration',
        'element' => 'MedicationAdministration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationAdministration',
      ),
      'MedicationDispense' =>
      array (
        'setter' => 'setMedicationDispense',
        'element' => 'MedicationDispense',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationDispense',
      ),
      'MedicationRequest' =>
      array (
        'setter' => 'setMedicationRequest',
        'element' => 'MedicationRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationRequest',
      ),
      'MedicationStatement' =>
      array (
        'setter' => 'setMedicationStatement',
        'element' => 'MedicationStatement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationStatement',
      ),
      'MessageDefinition' =>
      array (
        'setter' => 'setMessageDefinition',
        'element' => 'MessageDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMessageDefinition',
      ),
      'MessageHeader' =>
      array (
        'setter' => 'setMessageHeader',
        'element' => 'MessageHeader',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMessageHeader',
      ),
      'NamingSystem' =>
      array (
        'setter' => 'setNamingSystem',
        'element' => 'NamingSystem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRNamingSystem',
      ),
      'NutritionOrder' =>
      array (
        'setter' => 'setNutritionOrder',
        'element' => 'NutritionOrder',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRNutritionOrder',
      ),
      'Observation' =>
      array (
        'setter' => 'setObservation',
        'element' => 'Observation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRObservation',
      ),
      'OperationDefinition' =>
      array (
        'setter' => 'setOperationDefinition',
        'element' => 'OperationDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROperationDefinition',
      ),
      'OperationOutcome' =>
      array (
        'setter' => 'setOperationOutcome',
        'element' => 'OperationOutcome',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROperationOutcome',
      ),
      'Organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Organization',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROrganization',
      ),
      'Patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Patient',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPatient',
      ),
      'PaymentNotice' =>
      array (
        'setter' => 'setPaymentNotice',
        'element' => 'PaymentNotice',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPaymentNotice',
      ),
      'PaymentReconciliation' =>
      array (
        'setter' => 'setPaymentReconciliation',
        'element' => 'PaymentReconciliation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPaymentReconciliation',
      ),
      'Person' =>
      array (
        'setter' => 'setPerson',
        'element' => 'Person',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPerson',
      ),
      'PlanDefinition' =>
      array (
        'setter' => 'setPlanDefinition',
        'element' => 'PlanDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPlanDefinition',
      ),
      'Practitioner' =>
      array (
        'setter' => 'setPractitioner',
        'element' => 'Practitioner',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPractitioner',
      ),
      'PractitionerRole' =>
      array (
        'setter' => 'setPractitionerRole',
        'element' => 'PractitionerRole',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPractitionerRole',
      ),
      'Procedure' =>
      array (
        'setter' => 'setProcedure',
        'element' => 'Procedure',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcedure',
      ),
      'ProcedureRequest' =>
      array (
        'setter' => 'setProcedureRequest',
        'element' => 'ProcedureRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcedureRequest',
      ),
      'ProcessRequest' =>
      array (
        'setter' => 'setProcessRequest',
        'element' => 'ProcessRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcessRequest',
      ),
      'ProcessResponse' =>
      array (
        'setter' => 'setProcessResponse',
        'element' => 'ProcessResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProcessResponse',
      ),
      'Provenance' =>
      array (
        'setter' => 'setProvenance',
        'element' => 'Provenance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRProvenance',
      ),
      'Questionnaire' =>
      array (
        'setter' => 'setQuestionnaire',
        'element' => 'Questionnaire',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRQuestionnaire',
      ),
      'QuestionnaireResponse' =>
      array (
        'setter' => 'setQuestionnaireResponse',
        'element' => 'QuestionnaireResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRQuestionnaireResponse',
      ),
      'ReferralRequest' =>
      array (
        'setter' => 'setReferralRequest',
        'element' => 'ReferralRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRReferralRequest',
      ),
      'RelatedPerson' =>
      array (
        'setter' => 'setRelatedPerson',
        'element' => 'RelatedPerson',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRRelatedPerson',
      ),
      'RequestGroup' =>
      array (
        'setter' => 'setRequestGroup',
        'element' => 'RequestGroup',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRRequestGroup',
      ),
      'ResearchStudy' =>
      array (
        'setter' => 'setResearchStudy',
        'element' => 'ResearchStudy',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRResearchStudy',
      ),
      'ResearchSubject' =>
      array (
        'setter' => 'setResearchSubject',
        'element' => 'ResearchSubject',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRResearchSubject',
      ),
      'RiskAssessment' =>
      array (
        'setter' => 'setRiskAssessment',
        'element' => 'RiskAssessment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRRiskAssessment',
      ),
      'Schedule' =>
      array (
        'setter' => 'setSchedule',
        'element' => 'Schedule',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSchedule',
      ),
      'SearchParameter' =>
      array (
        'setter' => 'setSearchParameter',
        'element' => 'SearchParameter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSearchParameter',
      ),
      'Sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'Sequence',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSequence',
      ),
      'ServiceDefinition' =>
      array (
        'setter' => 'setServiceDefinition',
        'element' => 'ServiceDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRServiceDefinition',
      ),
      'Slot' =>
      array (
        'setter' => 'setSlot',
        'element' => 'Slot',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSlot',
      ),
      'Specimen' =>
      array (
        'setter' => 'setSpecimen',
        'element' => 'Specimen',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSpecimen',
      ),
      'StructureDefinition' =>
      array (
        'setter' => 'setStructureDefinition',
        'element' => 'StructureDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRStructureDefinition',
      ),
      'StructureMap' =>
      array (
        'setter' => 'setStructureMap',
        'element' => 'StructureMap',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRStructureMap',
      ),
      'Subscription' =>
      array (
        'setter' => 'setSubscription',
        'element' => 'Subscription',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSubscription',
      ),
      'Substance' =>
      array (
        'setter' => 'setSubstance',
        'element' => 'Substance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSubstance',
      ),
      'SupplyDelivery' =>
      array (
        'setter' => 'setSupplyDelivery',
        'element' => 'SupplyDelivery',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSupplyDelivery',
      ),
      'SupplyRequest' =>
      array (
        'setter' => 'setSupplyRequest',
        'element' => 'SupplyRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRSupplyRequest',
      ),
      'Task' =>
      array (
        'setter' => 'setTask',
        'element' => 'Task',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRTask',
      ),
      'TestReport' =>
      array (
        'setter' => 'setTestReport',
        'element' => 'TestReport',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRTestReport',
      ),
      'TestScript' =>
      array (
        'setter' => 'setTestScript',
        'element' => 'TestScript',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRTestScript',
      ),
      'ValueSet' =>
      array (
        'setter' => 'setValueSet',
        'element' => 'ValueSet',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRValueSet',
      ),
      'VisionPrescription' =>
      array (
        'setter' => 'setVisionPrescription',
        'element' => 'VisionPrescription',
        'type' => 'HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRVisionPrescription',
      ),
      'Parameters' =>
      array (
        'setter' => 'setParameters',
        'element' => 'Parameters',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters',
      ),
    ),
    ),
    'Extension' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'valueBase64Binary' =>
      array (
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'valueDate' =>
      array (
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'valueId' =>
      array (
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'valueInstant' =>
      array (
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'valueMarkdown' =>
      array (
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'valueOid' =>
      array (
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'valuePositiveInt' =>
      array (
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'valueUnsignedInt' =>
      array (
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'valueUri' =>
      array (
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'valueAddress' =>
      array (
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'valueAge' =>
      array (
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'valueAnnotation' =>
      array (
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'valueContactPoint' =>
      array (
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'valueCount' =>
      array (
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'valueDistance' =>
      array (
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'valueHumanName' =>
      array (
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'valueIdentifier' =>
      array (
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'valueMoney' =>
      array (
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'valueSignature' =>
      array (
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
      'valueTiming' =>
      array (
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'valueMeta' =>
      array (
        'setter' => 'setValueMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'BackboneElement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRBackboneElement',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
    ),
    ),
    'Narrative' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'NarrativeStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrativeStatus',
      ),
      'div' =>
      array (
        'setter' => 'setDiv',
        'element' => 'html',
        'type' => 'string',
      ),
    ),
    ),
    'NarrativeStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrativeStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NarrativeStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Element' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement',
    'extendedElementName' => null,
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'Reference' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Quantity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'QuantityComparator' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'QuantityComparator-list',
        'type' => 'string',
      ),
    ),
    ),
    'Period' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'end' =>
      array (
        'setter' => 'setEnd',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Attachment' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'contentType' =>
      array (
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'data' =>
      array (
        'setter' => 'setData',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'size' =>
      array (
        'setter' => 'setSize',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'hash' =>
      array (
        'setter' => 'setHash',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'creation' =>
      array (
        'setter' => 'setCreation',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'Duration' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Count' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Range' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'low' =>
      array (
        'setter' => 'setLow',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'high' =>
      array (
        'setter' => 'setHigh',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Annotation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'authorReference' =>
      array (
        'setter' => 'setAuthorReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'authorString' =>
      array (
        'setter' => 'setAuthorString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'time' =>
      array (
        'setter' => 'setTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Money' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Identifier' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'IdentifierUse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifierUse',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'assigner' =>
      array (
        'setter' => 'setAssigner',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'IdentifierUse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifierUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'IdentifierUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'Coding' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'userSelected' =>
      array (
        'setter' => 'setUserSelected',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'Signature' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'when' =>
      array (
        'setter' => 'setWhen',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'whoUri' =>
      array (
        'setter' => 'setWhoUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'whoReference' =>
      array (
        'setter' => 'setWhoReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOfUri' =>
      array (
        'setter' => 'setOnBehalfOfUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'onBehalfOfReference' =>
      array (
        'setter' => 'setOnBehalfOfReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'contentType' =>
      array (
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'blob' =>
      array (
        'setter' => 'setBlob',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'SampledData' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'origin' =>
      array (
        'setter' => 'setOrigin',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'lowerLimit' =>
      array (
        'setter' => 'setLowerLimit',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'upperLimit' =>
      array (
        'setter' => 'setUpperLimit',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'dimensions' =>
      array (
        'setter' => 'setDimensions',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'data' =>
      array (
        'setter' => 'setData',
        'element' => 'SampledDataDataType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledDataDataType',
      ),
    ),
    ),
    'SampledDataDataType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledDataDataType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SampledDataDataType-primitive',
        'type' => 'string',
      ),
    ),
    ),
    'Ratio' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'numerator' =>
      array (
        'setter' => 'setNumerator',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'denominator' =>
      array (
        'setter' => 'setDenominator',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Distance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'Age' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
    'extendedElementName' => 'Quantity',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'comparator' =>
      array (
        'setter' => 'setComparator',
        'element' => 'QuantityComparator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantityComparator',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'CodeableConcept' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'coding' =>
      array (
        'setter' => 'addCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Meta' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'versionId' =>
      array (
        'setter' => 'setVersionId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'lastUpdated' =>
      array (
        'setter' => 'setLastUpdated',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'profile' =>
      array (
        'setter' => 'addProfile',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'security' =>
      array (
        'setter' => 'addSecurity',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'tag' =>
      array (
        'setter' => 'addTag',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'Address' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'AddressUse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddressUse',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'AddressType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddressType',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'line' =>
      array (
        'setter' => 'addLine',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'city' =>
      array (
        'setter' => 'setCity',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'district' =>
      array (
        'setter' => 'setDistrict',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'state' =>
      array (
        'setter' => 'setState',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'postalCode' =>
      array (
        'setter' => 'setPostalCode',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'country' =>
      array (
        'setter' => 'setCountry',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'AddressUse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddressUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AddressUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'AddressType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddressType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AddressType-list',
        'type' => 'string',
      ),
    ),
    ),
    'TriggerDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRTriggerDefinition',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'TriggerType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTriggerType',
      ),
      'eventName' =>
      array (
        'setter' => 'setEventName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'eventTimingTiming' =>
      array (
        'setter' => 'setEventTimingTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'eventTimingReference' =>
      array (
        'setter' => 'setEventTimingReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'eventTimingDate' =>
      array (
        'setter' => 'setEventTimingDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'eventTimingDateTime' =>
      array (
        'setter' => 'setEventTimingDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'eventData' =>
      array (
        'setter' => 'setEventData',
        'element' => 'DataRequirement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataRequirement',
      ),
    ),
    ),
    'TriggerType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRTriggerType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'TriggerType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Contributor' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributor',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ContributorType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributorType',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
    ),
    ),
    'ContributorType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributorType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContributorType-list',
        'type' => 'string',
      ),
    ),
    ),
    'DataRequirement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataRequirement',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'addProfile',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'mustSupport' =>
      array (
        'setter' => 'addMustSupport',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'codeFilter' =>
      array (
        'setter' => 'addCodeFilter',
        'element' => 'DataRequirement.CodeFilter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementCodeFilter',
      ),
      'dateFilter' =>
      array (
        'setter' => 'addDateFilter',
        'element' => 'DataRequirement.DateFilter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementDateFilter',
      ),
    ),
    ),
    'DataRequirement.CodeFilter' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementCodeFilter',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueSetString' =>
      array (
        'setter' => 'setValueSetString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueSetReference' =>
      array (
        'setter' => 'setValueSetReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'valueCode' =>
      array (
        'setter' => 'addValueCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'valueCoding' =>
      array (
        'setter' => 'addValueCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'addValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'DataRequirement.DateFilter' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataRequirement\\FHIRDataRequirementDateFilter',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
    ),
    ),
    'Dosage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDosage',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'additionalInstruction' =>
      array (
        'setter' => 'addAdditionalInstruction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patientInstruction' =>
      array (
        'setter' => 'setPatientInstruction',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'timing' =>
      array (
        'setter' => 'setTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'asNeededBoolean' =>
      array (
        'setter' => 'setAsNeededBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'asNeededCodeableConcept' =>
      array (
        'setter' => 'setAsNeededCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'route' =>
      array (
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseRange' =>
      array (
        'setter' => 'setDoseRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'doseQuantity' =>
      array (
        'setter' => 'setDoseQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'maxDosePerPeriod' =>
      array (
        'setter' => 'setMaxDosePerPeriod',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'maxDosePerAdministration' =>
      array (
        'setter' => 'setMaxDosePerAdministration',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'maxDosePerLifetime' =>
      array (
        'setter' => 'setMaxDosePerLifetime',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'rateRatio' =>
      array (
        'setter' => 'setRateRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'rateRange' =>
      array (
        'setter' => 'setRateRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'rateQuantity' =>
      array (
        'setter' => 'setRateQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'RelatedArtifact' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifact',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'RelatedArtifactType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifactType',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'citation' =>
      array (
        'setter' => 'setCitation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'document' =>
      array (
        'setter' => 'setDocument',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'resource' =>
      array (
        'setter' => 'setResource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'RelatedArtifactType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifactType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RelatedArtifactType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ContactDetail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
    ),
    ),
    'HumanName' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'NameUse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNameUse',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'family' =>
      array (
        'setter' => 'setFamily',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'given' =>
      array (
        'setter' => 'addGiven',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'prefix' =>
      array (
        'setter' => 'addPrefix',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'suffix' =>
      array (
        'setter' => 'addSuffix',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'NameUse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNameUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NameUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'ContactPoint' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'ContactPointSystem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPointSystem',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'ContactPointUse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPointUse',
      ),
      'rank' =>
      array (
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'ContactPointSystem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPointSystem',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContactPointSystem-list',
        'type' => 'string',
      ),
    ),
    ),
    'ContactPointUse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPointUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContactPointUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'UsageContext' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
    ),
    ),
    'Timing' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'repeat' =>
      array (
        'setter' => 'setRepeat',
        'element' => 'Timing.Repeat',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRTiming\\FHIRTimingRepeat',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Timing.Repeat' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRTiming\\FHIRTimingRepeat',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'boundsDuration' =>
      array (
        'setter' => 'setBoundsDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'boundsRange' =>
      array (
        'setter' => 'setBoundsRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'boundsPeriod' =>
      array (
        'setter' => 'setBoundsPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'count' =>
      array (
        'setter' => 'setCount',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'countMax' =>
      array (
        'setter' => 'setCountMax',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'duration' =>
      array (
        'setter' => 'setDuration',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'durationMax' =>
      array (
        'setter' => 'setDurationMax',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'durationUnit' =>
      array (
        'setter' => 'setDurationUnit',
        'element' => 'UnitsOfTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnitsOfTime',
      ),
      'frequency' =>
      array (
        'setter' => 'setFrequency',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'frequencyMax' =>
      array (
        'setter' => 'setFrequencyMax',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'periodMax' =>
      array (
        'setter' => 'setPeriodMax',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'periodUnit' =>
      array (
        'setter' => 'setPeriodUnit',
        'element' => 'UnitsOfTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnitsOfTime',
      ),
      'dayOfWeek' =>
      array (
        'setter' => 'addDayOfWeek',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'timeOfDay' =>
      array (
        'setter' => 'addTimeOfDay',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'when' =>
      array (
        'setter' => 'addWhen',
        'element' => 'EventTiming',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventTiming',
      ),
      'offset' =>
      array (
        'setter' => 'setOffset',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
    ),
    ),
    'UnitsOfTime' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnitsOfTime',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'UnitsOfTime-list',
        'type' => 'string',
      ),
    ),
    ),
    'EventTiming' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREventTiming',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EventTiming-list',
        'type' => 'string',
      ),
    ),
    ),
    'ElementDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRElementDefinition',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'representation' =>
      array (
        'setter' => 'addRepresentation',
        'element' => 'PropertyRepresentation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPropertyRepresentation',
      ),
      'sliceName' =>
      array (
        'setter' => 'setSliceName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'label' =>
      array (
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'slicing' =>
      array (
        'setter' => 'setSlicing',
        'element' => 'ElementDefinition.Slicing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionSlicing',
      ),
      'short' =>
      array (
        'setter' => 'setShort',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'requirements' =>
      array (
        'setter' => 'setRequirements',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'alias' =>
      array (
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'base' =>
      array (
        'setter' => 'setBase',
        'element' => 'ElementDefinition.Base',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBase',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'ElementDefinition.Type',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionType',
      ),
      'defaultValueBase64Binary' =>
      array (
        'setter' => 'setDefaultValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'defaultValueBoolean' =>
      array (
        'setter' => 'setDefaultValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'defaultValueCode' =>
      array (
        'setter' => 'setDefaultValueCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'defaultValueDate' =>
      array (
        'setter' => 'setDefaultValueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'defaultValueDateTime' =>
      array (
        'setter' => 'setDefaultValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'defaultValueDecimal' =>
      array (
        'setter' => 'setDefaultValueDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'defaultValueId' =>
      array (
        'setter' => 'setDefaultValueId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'defaultValueInstant' =>
      array (
        'setter' => 'setDefaultValueInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'defaultValueInteger' =>
      array (
        'setter' => 'setDefaultValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'defaultValueMarkdown' =>
      array (
        'setter' => 'setDefaultValueMarkdown',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'defaultValueOid' =>
      array (
        'setter' => 'setDefaultValueOid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'defaultValuePositiveInt' =>
      array (
        'setter' => 'setDefaultValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'defaultValueString' =>
      array (
        'setter' => 'setDefaultValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'defaultValueTime' =>
      array (
        'setter' => 'setDefaultValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'defaultValueUnsignedInt' =>
      array (
        'setter' => 'setDefaultValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'defaultValueUri' =>
      array (
        'setter' => 'setDefaultValueUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'defaultValueAddress' =>
      array (
        'setter' => 'setDefaultValueAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'defaultValueAge' =>
      array (
        'setter' => 'setDefaultValueAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'defaultValueAnnotation' =>
      array (
        'setter' => 'setDefaultValueAnnotation',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'defaultValueAttachment' =>
      array (
        'setter' => 'setDefaultValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'defaultValueCodeableConcept' =>
      array (
        'setter' => 'setDefaultValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'defaultValueCoding' =>
      array (
        'setter' => 'setDefaultValueCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'defaultValueContactPoint' =>
      array (
        'setter' => 'setDefaultValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'defaultValueCount' =>
      array (
        'setter' => 'setDefaultValueCount',
        'element' => 'Count',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'defaultValueDistance' =>
      array (
        'setter' => 'setDefaultValueDistance',
        'element' => 'Distance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'defaultValueDuration' =>
      array (
        'setter' => 'setDefaultValueDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'defaultValueHumanName' =>
      array (
        'setter' => 'setDefaultValueHumanName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'defaultValueIdentifier' =>
      array (
        'setter' => 'setDefaultValueIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'defaultValueMoney' =>
      array (
        'setter' => 'setDefaultValueMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'defaultValuePeriod' =>
      array (
        'setter' => 'setDefaultValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'defaultValueQuantity' =>
      array (
        'setter' => 'setDefaultValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'defaultValueRange' =>
      array (
        'setter' => 'setDefaultValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'defaultValueRatio' =>
      array (
        'setter' => 'setDefaultValueRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'defaultValueReference' =>
      array (
        'setter' => 'setDefaultValueReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'defaultValueSampledData' =>
      array (
        'setter' => 'setDefaultValueSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'defaultValueSignature' =>
      array (
        'setter' => 'setDefaultValueSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
      'defaultValueTiming' =>
      array (
        'setter' => 'setDefaultValueTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'defaultValueMeta' =>
      array (
        'setter' => 'setDefaultValueMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'meaningWhenMissing' =>
      array (
        'setter' => 'setMeaningWhenMissing',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'orderMeaning' =>
      array (
        'setter' => 'setOrderMeaning',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'fixedBase64Binary' =>
      array (
        'setter' => 'setFixedBase64Binary',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'fixedBoolean' =>
      array (
        'setter' => 'setFixedBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'fixedCode' =>
      array (
        'setter' => 'setFixedCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'fixedDate' =>
      array (
        'setter' => 'setFixedDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'fixedDateTime' =>
      array (
        'setter' => 'setFixedDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'fixedDecimal' =>
      array (
        'setter' => 'setFixedDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'fixedId' =>
      array (
        'setter' => 'setFixedId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'fixedInstant' =>
      array (
        'setter' => 'setFixedInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'fixedInteger' =>
      array (
        'setter' => 'setFixedInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'fixedMarkdown' =>
      array (
        'setter' => 'setFixedMarkdown',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'fixedOid' =>
      array (
        'setter' => 'setFixedOid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'fixedPositiveInt' =>
      array (
        'setter' => 'setFixedPositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'fixedString' =>
      array (
        'setter' => 'setFixedString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'fixedTime' =>
      array (
        'setter' => 'setFixedTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'fixedUnsignedInt' =>
      array (
        'setter' => 'setFixedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'fixedUri' =>
      array (
        'setter' => 'setFixedUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'fixedAddress' =>
      array (
        'setter' => 'setFixedAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'fixedAge' =>
      array (
        'setter' => 'setFixedAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'fixedAnnotation' =>
      array (
        'setter' => 'setFixedAnnotation',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'fixedAttachment' =>
      array (
        'setter' => 'setFixedAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'fixedCodeableConcept' =>
      array (
        'setter' => 'setFixedCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fixedCoding' =>
      array (
        'setter' => 'setFixedCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'fixedContactPoint' =>
      array (
        'setter' => 'setFixedContactPoint',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'fixedCount' =>
      array (
        'setter' => 'setFixedCount',
        'element' => 'Count',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'fixedDistance' =>
      array (
        'setter' => 'setFixedDistance',
        'element' => 'Distance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'fixedDuration' =>
      array (
        'setter' => 'setFixedDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'fixedHumanName' =>
      array (
        'setter' => 'setFixedHumanName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'fixedIdentifier' =>
      array (
        'setter' => 'setFixedIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'fixedMoney' =>
      array (
        'setter' => 'setFixedMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'fixedPeriod' =>
      array (
        'setter' => 'setFixedPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'fixedQuantity' =>
      array (
        'setter' => 'setFixedQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'fixedRange' =>
      array (
        'setter' => 'setFixedRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'fixedRatio' =>
      array (
        'setter' => 'setFixedRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'fixedReference' =>
      array (
        'setter' => 'setFixedReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'fixedSampledData' =>
      array (
        'setter' => 'setFixedSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'fixedSignature' =>
      array (
        'setter' => 'setFixedSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
      'fixedTiming' =>
      array (
        'setter' => 'setFixedTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'fixedMeta' =>
      array (
        'setter' => 'setFixedMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'patternBase64Binary' =>
      array (
        'setter' => 'setPatternBase64Binary',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'patternBoolean' =>
      array (
        'setter' => 'setPatternBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'patternCode' =>
      array (
        'setter' => 'setPatternCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'patternDate' =>
      array (
        'setter' => 'setPatternDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'patternDateTime' =>
      array (
        'setter' => 'setPatternDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'patternDecimal' =>
      array (
        'setter' => 'setPatternDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'patternId' =>
      array (
        'setter' => 'setPatternId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'patternInstant' =>
      array (
        'setter' => 'setPatternInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'patternInteger' =>
      array (
        'setter' => 'setPatternInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'patternMarkdown' =>
      array (
        'setter' => 'setPatternMarkdown',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'patternOid' =>
      array (
        'setter' => 'setPatternOid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'patternPositiveInt' =>
      array (
        'setter' => 'setPatternPositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'patternString' =>
      array (
        'setter' => 'setPatternString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'patternTime' =>
      array (
        'setter' => 'setPatternTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'patternUnsignedInt' =>
      array (
        'setter' => 'setPatternUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'patternUri' =>
      array (
        'setter' => 'setPatternUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'patternAddress' =>
      array (
        'setter' => 'setPatternAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'patternAge' =>
      array (
        'setter' => 'setPatternAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'patternAnnotation' =>
      array (
        'setter' => 'setPatternAnnotation',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'patternAttachment' =>
      array (
        'setter' => 'setPatternAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'patternCodeableConcept' =>
      array (
        'setter' => 'setPatternCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patternCoding' =>
      array (
        'setter' => 'setPatternCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'patternContactPoint' =>
      array (
        'setter' => 'setPatternContactPoint',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'patternCount' =>
      array (
        'setter' => 'setPatternCount',
        'element' => 'Count',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'patternDistance' =>
      array (
        'setter' => 'setPatternDistance',
        'element' => 'Distance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'patternDuration' =>
      array (
        'setter' => 'setPatternDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'patternHumanName' =>
      array (
        'setter' => 'setPatternHumanName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'patternIdentifier' =>
      array (
        'setter' => 'setPatternIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'patternMoney' =>
      array (
        'setter' => 'setPatternMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'patternPeriod' =>
      array (
        'setter' => 'setPatternPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'patternQuantity' =>
      array (
        'setter' => 'setPatternQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'patternRange' =>
      array (
        'setter' => 'setPatternRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'patternRatio' =>
      array (
        'setter' => 'setPatternRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'patternReference' =>
      array (
        'setter' => 'setPatternReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'patternSampledData' =>
      array (
        'setter' => 'setPatternSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'patternSignature' =>
      array (
        'setter' => 'setPatternSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
      'patternTiming' =>
      array (
        'setter' => 'setPatternTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'patternMeta' =>
      array (
        'setter' => 'setPatternMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'example' =>
      array (
        'setter' => 'addExample',
        'element' => 'ElementDefinition.Example',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionExample',
      ),
      'minValueDate' =>
      array (
        'setter' => 'setMinValueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'minValueDateTime' =>
      array (
        'setter' => 'setMinValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'minValueInstant' =>
      array (
        'setter' => 'setMinValueInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'minValueTime' =>
      array (
        'setter' => 'setMinValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'minValueDecimal' =>
      array (
        'setter' => 'setMinValueDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'minValueInteger' =>
      array (
        'setter' => 'setMinValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'minValuePositiveInt' =>
      array (
        'setter' => 'setMinValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'minValueUnsignedInt' =>
      array (
        'setter' => 'setMinValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'minValueQuantity' =>
      array (
        'setter' => 'setMinValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'maxValueDate' =>
      array (
        'setter' => 'setMaxValueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'maxValueDateTime' =>
      array (
        'setter' => 'setMaxValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'maxValueInstant' =>
      array (
        'setter' => 'setMaxValueInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'maxValueTime' =>
      array (
        'setter' => 'setMaxValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'maxValueDecimal' =>
      array (
        'setter' => 'setMaxValueDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'maxValueInteger' =>
      array (
        'setter' => 'setMaxValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'maxValuePositiveInt' =>
      array (
        'setter' => 'setMaxValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'maxValueUnsignedInt' =>
      array (
        'setter' => 'setMaxValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'maxValueQuantity' =>
      array (
        'setter' => 'setMaxValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'maxLength' =>
      array (
        'setter' => 'setMaxLength',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'condition' =>
      array (
        'setter' => 'addCondition',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'constraint' =>
      array (
        'setter' => 'addConstraint',
        'element' => 'ElementDefinition.Constraint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionConstraint',
      ),
      'mustSupport' =>
      array (
        'setter' => 'setMustSupport',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'isModifier' =>
      array (
        'setter' => 'setIsModifier',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'isSummary' =>
      array (
        'setter' => 'setIsSummary',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'binding' =>
      array (
        'setter' => 'setBinding',
        'element' => 'ElementDefinition.Binding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBinding',
      ),
      'mapping' =>
      array (
        'setter' => 'addMapping',
        'element' => 'ElementDefinition.Mapping',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionMapping',
      ),
    ),
    ),
    'ElementDefinition.Constraint' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionConstraint',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'key' =>
      array (
        'setter' => 'setKey',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'requirements' =>
      array (
        'setter' => 'setRequirements',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'ConstraintSeverity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConstraintSeverity',
      ),
      'human' =>
      array (
        'setter' => 'setHuman',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'xpath' =>
      array (
        'setter' => 'setXpath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'ElementDefinition.Mapping' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionMapping',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'identity' =>
      array (
        'setter' => 'setIdentity',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'map' =>
      array (
        'setter' => 'setMap',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ElementDefinition.Base' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBase',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ElementDefinition.Type' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'targetProfile' =>
      array (
        'setter' => 'setTargetProfile',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'aggregation' =>
      array (
        'setter' => 'addAggregation',
        'element' => 'AggregationMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAggregationMode',
      ),
      'versioning' =>
      array (
        'setter' => 'setVersioning',
        'element' => 'ReferenceVersionRules',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReferenceVersionRules',
      ),
    ),
    ),
    'ElementDefinition.Example' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionExample',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'label' =>
      array (
        'setter' => 'setLabel',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueBase64Binary' =>
      array (
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'valueDate' =>
      array (
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'valueId' =>
      array (
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'valueInstant' =>
      array (
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'valueMarkdown' =>
      array (
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'valueOid' =>
      array (
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'valuePositiveInt' =>
      array (
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'valueUnsignedInt' =>
      array (
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'valueUri' =>
      array (
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'valueAddress' =>
      array (
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'valueAge' =>
      array (
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'valueAnnotation' =>
      array (
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'valueContactPoint' =>
      array (
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'valueCount' =>
      array (
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'valueDistance' =>
      array (
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'valueHumanName' =>
      array (
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'valueIdentifier' =>
      array (
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'valueMoney' =>
      array (
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'valueSignature' =>
      array (
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
      'valueTiming' =>
      array (
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'valueMeta' =>
      array (
        'setter' => 'setValueMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
    ),
    ),
    'ElementDefinition.Slicing' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionSlicing',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'discriminator' =>
      array (
        'setter' => 'addDiscriminator',
        'element' => 'ElementDefinition.Discriminator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionDiscriminator',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'ordered' =>
      array (
        'setter' => 'setOrdered',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'rules' =>
      array (
        'setter' => 'setRules',
        'element' => 'SlicingRules',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSlicingRules',
      ),
    ),
    ),
    'ElementDefinition.Binding' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionBinding',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'strength' =>
      array (
        'setter' => 'setStrength',
        'element' => 'BindingStrength',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBindingStrength',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueSetUri' =>
      array (
        'setter' => 'setValueSetUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'valueSetReference' =>
      array (
        'setter' => 'setValueSetReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ElementDefinition.Discriminator' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRElementDefinition\\FHIRElementDefinitionDiscriminator',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DiscriminatorType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDiscriminatorType',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'PropertyRepresentation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRPropertyRepresentation',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'PropertyRepresentation-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConstraintSeverity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConstraintSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConstraintSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'AggregationMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAggregationMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AggregationMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ReferenceVersionRules' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRReferenceVersionRules',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ReferenceVersionRules-list',
        'type' => 'string',
      ),
    ),
    ),
    'SlicingRules' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSlicingRules',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SlicingRules-list',
        'type' => 'string',
      ),
    ),
    ),
    'BindingStrength' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRBindingStrength',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BindingStrength-list',
        'type' => 'string',
      ),
    ),
    ),
    'DiscriminatorType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDiscriminatorType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DiscriminatorType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ParameterDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRParameterDefinition',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DomainResource' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDomainResource',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
    ),
    ),
    'Resource' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource',
    'extendedElementName' => null,
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
    ),
    ),
    'PublicationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'PublicationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'SearchParamType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchParamType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SearchParamType-list',
        'type' => 'string',
      ),
    ),
    ),
    'AdministrativeGender' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdministrativeGender',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AdministrativeGender-list',
        'type' => 'string',
      ),
    ),
    ),
    'RemittanceOutcome' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRemittanceOutcome',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RemittanceOutcome-list',
        'type' => 'string',
      ),
    ),
    ),
    'NoteType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNoteType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NoteType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConceptMapEquivalence' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConceptMapEquivalence',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConceptMapEquivalence-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentReferenceStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentReferenceStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DocumentReferenceStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Account' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAccount',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'AccountStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAccountStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'balance' =>
      array (
        'setter' => 'setBalance',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'coverage' =>
      array (
        'setter' => 'addCoverage',
        'element' => 'Account.Coverage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAccount\\FHIRAccountCoverage',
      ),
      'owner' =>
      array (
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'guarantor' =>
      array (
        'setter' => 'addGuarantor',
        'element' => 'Account.Guarantor',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAccount\\FHIRAccountGuarantor',
      ),
    ),
    ),
    'Account.Coverage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAccount\\FHIRAccountCoverage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
    ),
    ),
    'Account.Guarantor' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAccount\\FHIRAccountGuarantor',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onHold' =>
      array (
        'setter' => 'setOnHold',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'AccountStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAccountStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AccountStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ActivityDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRActivityDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'usage' =>
      array (
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contributor' =>
      array (
        'setter' => 'addContributor',
        'element' => 'Contributor',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributor',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'library' =>
      array (
        'setter' => 'addLibrary',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'timingTiming' =>
      array (
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'timingDateTime' =>
      array (
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'timingRange' =>
      array (
        'setter' => 'setTimingRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'ActivityDefinition.Participant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionParticipant',
      ),
      'productReference' =>
      array (
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'productCodeableConcept' =>
      array (
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'dosage' =>
      array (
        'setter' => 'addDosage',
        'element' => 'Dosage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDosage',
      ),
      'bodySite' =>
      array (
        'setter' => 'addBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'transform' =>
      array (
        'setter' => 'setTransform',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'dynamicValue' =>
      array (
        'setter' => 'addDynamicValue',
        'element' => 'ActivityDefinition.DynamicValue',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionDynamicValue',
      ),
    ),
    ),
    'ActivityDefinition.Participant' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ActionParticipantType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionParticipantType',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ActivityDefinition.DynamicValue' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRActivityDefinition\\FHIRActivityDefinitionDynamicValue',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ActionParticipantType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRActionParticipantType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ActionParticipantType-list',
        'type' => 'string',
      ),
    ),
    ),
    'ResourceType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ResourceType-list',
        'type' => 'string',
      ),
    ),
    ),
    'AdverseEvent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAdverseEvent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'AdverseEventCategory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdverseEventCategory',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'reaction' =>
      array (
        'setter' => 'addReaction',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'seriousness' =>
      array (
        'setter' => 'setSeriousness',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'recorder' =>
      array (
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'eventParticipant' =>
      array (
        'setter' => 'setEventParticipant',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'suspectEntity' =>
      array (
        'setter' => 'addSuspectEntity',
        'element' => 'AdverseEvent.SuspectEntity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventSuspectEntity',
      ),
      'subjectMedicalHistory' =>
      array (
        'setter' => 'addSubjectMedicalHistory',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'referenceDocument' =>
      array (
        'setter' => 'addReferenceDocument',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'study' =>
      array (
        'setter' => 'addStudy',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'AdverseEvent.SuspectEntity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAdverseEvent\\FHIRAdverseEventSuspectEntity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'instance' =>
      array (
        'setter' => 'setInstance',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'causality' =>
      array (
        'setter' => 'setCausality',
        'element' => 'AdverseEventCausality',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdverseEventCausality',
      ),
      'causalityAssessment' =>
      array (
        'setter' => 'setCausalityAssessment',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'causalityProductRelatedness' =>
      array (
        'setter' => 'setCausalityProductRelatedness',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'causalityMethod' =>
      array (
        'setter' => 'setCausalityMethod',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'causalityAuthor' =>
      array (
        'setter' => 'setCausalityAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'causalityResult' =>
      array (
        'setter' => 'setCausalityResult',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'AdverseEventCausality' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdverseEventCausality',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AdverseEventCausality-list',
        'type' => 'string',
      ),
    ),
    ),
    'AdverseEventCategory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdverseEventCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AdverseEventCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntolerance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAllergyIntolerance',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'clinicalStatus' =>
      array (
        'setter' => 'setClinicalStatus',
        'element' => 'AllergyIntoleranceClinicalStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceClinicalStatus',
      ),
      'verificationStatus' =>
      array (
        'setter' => 'setVerificationStatus',
        'element' => 'AllergyIntoleranceVerificationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceVerificationStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'AllergyIntoleranceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceType',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'AllergyIntoleranceCategory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceCategory',
      ),
      'criticality' =>
      array (
        'setter' => 'setCriticality',
        'element' => 'AllergyIntoleranceCriticality',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceCriticality',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onsetDateTime' =>
      array (
        'setter' => 'setOnsetDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'onsetAge' =>
      array (
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'onsetPeriod' =>
      array (
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'onsetRange' =>
      array (
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'onsetString' =>
      array (
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'assertedDate' =>
      array (
        'setter' => 'setAssertedDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'recorder' =>
      array (
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'asserter' =>
      array (
        'setter' => 'setAsserter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'lastOccurrence' =>
      array (
        'setter' => 'setLastOccurrence',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'reaction' =>
      array (
        'setter' => 'addReaction',
        'element' => 'AllergyIntolerance.Reaction',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAllergyIntolerance\\FHIRAllergyIntoleranceReaction',
      ),
    ),
    ),
    'AllergyIntolerance.Reaction' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAllergyIntolerance\\FHIRAllergyIntoleranceReaction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'substance' =>
      array (
        'setter' => 'setSubstance',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'manifestation' =>
      array (
        'setter' => 'addManifestation',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'onset' =>
      array (
        'setter' => 'setOnset',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'AllergyIntoleranceSeverity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceSeverity',
      ),
      'exposureRoute' =>
      array (
        'setter' => 'setExposureRoute',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'AllergyIntoleranceCriticality' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceCriticality',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceCriticality-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceType-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceCategory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceVerificationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceVerificationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceVerificationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceSeverity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'AllergyIntoleranceClinicalStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAllergyIntoleranceClinicalStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AllergyIntoleranceClinicalStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Appointment' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAppointment',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'AppointmentStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAppointmentStatus',
      ),
      'serviceCategory' =>
      array (
        'setter' => 'setServiceCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'serviceType' =>
      array (
        'setter' => 'addServiceType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialty' =>
      array (
        'setter' => 'addSpecialty',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'appointmentType' =>
      array (
        'setter' => 'setAppointmentType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'indication' =>
      array (
        'setter' => 'addIndication',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'end' =>
      array (
        'setter' => 'setEnd',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'minutesDuration' =>
      array (
        'setter' => 'setMinutesDuration',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'slot' =>
      array (
        'setter' => 'addSlot',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'incomingReferral' =>
      array (
        'setter' => 'addIncomingReferral',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'Appointment.Participant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAppointment\\FHIRAppointmentParticipant',
      ),
      'requestedPeriod' =>
      array (
        'setter' => 'addRequestedPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Appointment.Participant' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAppointment\\FHIRAppointmentParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'required' =>
      array (
        'setter' => 'setRequired',
        'element' => 'ParticipantRequired',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipantRequired',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ParticipationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipationStatus',
      ),
    ),
    ),
    'ParticipantRequired' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipantRequired',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ParticipantRequired-list',
        'type' => 'string',
      ),
    ),
    ),
    'AppointmentStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAppointmentStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AppointmentStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ParticipationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ParticipationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'AppointmentResponse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAppointmentResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'appointment' =>
      array (
        'setter' => 'setAppointment',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'end' =>
      array (
        'setter' => 'setEnd',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'participantType' =>
      array (
        'setter' => 'addParticipantType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'participantStatus' =>
      array (
        'setter' => 'setParticipantStatus',
        'element' => 'ParticipationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParticipationStatus',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'AuditEvent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRAuditEvent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'subtype' =>
      array (
        'setter' => 'addSubtype',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'action' =>
      array (
        'setter' => 'setAction',
        'element' => 'AuditEventAction',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventAction',
      ),
      'recorded' =>
      array (
        'setter' => 'setRecorded',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'AuditEventOutcome',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventOutcome',
      ),
      'outcomeDesc' =>
      array (
        'setter' => 'setOutcomeDesc',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'purposeOfEvent' =>
      array (
        'setter' => 'addPurposeOfEvent',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'agent' =>
      array (
        'setter' => 'addAgent',
        'element' => 'AuditEvent.Agent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventAgent',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'AuditEvent.Source',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventSource',
      ),
      'entity' =>
      array (
        'setter' => 'addEntity',
        'element' => 'AuditEvent.Entity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventEntity',
      ),
    ),
    ),
    'AuditEvent.Agent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventAgent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'userId' =>
      array (
        'setter' => 'setUserId',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'altId' =>
      array (
        'setter' => 'setAltId',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'requestor' =>
      array (
        'setter' => 'setRequestor',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'policy' =>
      array (
        'setter' => 'addPolicy',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'media' =>
      array (
        'setter' => 'setMedia',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'AuditEvent.Network',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventNetwork',
      ),
      'purposeOfUse' =>
      array (
        'setter' => 'addPurposeOfUse',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'AuditEvent.Network' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventNetwork',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'AuditEventAgentNetworkType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventAgentNetworkType',
      ),
    ),
    ),
    'AuditEvent.Source' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventSource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'AuditEvent.Entity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventEntity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'lifecycle' =>
      array (
        'setter' => 'setLifecycle',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'query' =>
      array (
        'setter' => 'setQuery',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'AuditEvent.Detail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventDetail',
      ),
    ),
    ),
    'AuditEvent.Detail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRAuditEvent\\FHIRAuditEventDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'AuditEventOutcome' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventOutcome',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AuditEventOutcome-list',
        'type' => 'string',
      ),
    ),
    ),
    'AuditEventAction' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventAction',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AuditEventAction-list',
        'type' => 'string',
      ),
    ),
    ),
    'AuditEventAgentNetworkType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRAuditEventAgentNetworkType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'AuditEventAgentNetworkType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Basic' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRBasic',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Binary' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBinary',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'contentType' =>
      array (
        'setter' => 'setContentType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'securityContext' =>
      array (
        'setter' => 'setSecurityContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'content' =>
      array (
        'setter' => 'setContent',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'BodySite' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRBodySite',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'qualifier' =>
      array (
        'setter' => 'addQualifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'image' =>
      array (
        'setter' => 'addImage',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Bundle' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'BundleType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBundleType',
      ),
      'total' =>
      array (
        'setter' => 'setTotal',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'Bundle.Link',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleLink',
      ),
      'entry' =>
      array (
        'setter' => 'addEntry',
        'element' => 'Bundle.Entry',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleEntry',
      ),
      'signature' =>
      array (
        'setter' => 'setSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
    ),
    ),
    'Bundle.Link' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleLink',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'relation' =>
      array (
        'setter' => 'setRelation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'Bundle.Entry' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleEntry',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'Bundle.Link',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleLink',
      ),
      'fullUrl' =>
      array (
        'setter' => 'setFullUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'resource' =>
      array (
        'setter' => 'setResource',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'search' =>
      array (
        'setter' => 'setSearch',
        'element' => 'Bundle.Search',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleSearch',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Bundle.Request',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleRequest',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'Bundle.Response',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleResponse',
      ),
    ),
    ),
    'Bundle.Search' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleSearch',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'SearchEntryMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchEntryMode',
      ),
      'score' =>
      array (
        'setter' => 'setScore',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'Bundle.Request' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleRequest',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'HTTPVerb',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHTTPVerb',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'ifNoneMatch' =>
      array (
        'setter' => 'setIfNoneMatch',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'ifModifiedSince' =>
      array (
        'setter' => 'setIfModifiedSince',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'ifMatch' =>
      array (
        'setter' => 'setIfMatch',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'ifNoneExist' =>
      array (
        'setter' => 'setIfNoneExist',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Bundle.Response' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRBundle\\FHIRBundleResponse',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'etag' =>
      array (
        'setter' => 'setEtag',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'lastModified' =>
      array (
        'setter' => 'setLastModified',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
    ),
    ),
    'HTTPVerb' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRHTTPVerb',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'HTTPVerb-list',
        'type' => 'string',
      ),
    ),
    ),
    'BundleType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRBundleType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'BundleType-list',
        'type' => 'string',
      ),
    ),
    ),
    'SearchEntryMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchEntryMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SearchEntryMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'CapabilityStatement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCapabilityStatement',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'CapabilityStatementKind',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCapabilityStatementKind',
      ),
      'instantiates' =>
      array (
        'setter' => 'addInstantiates',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'software' =>
      array (
        'setter' => 'setSoftware',
        'element' => 'CapabilityStatement.Software',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSoftware',
      ),
      'implementation' =>
      array (
        'setter' => 'setImplementation',
        'element' => 'CapabilityStatement.Implementation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementImplementation',
      ),
      'fhirVersion' =>
      array (
        'setter' => 'setFhirVersion',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'acceptUnknown' =>
      array (
        'setter' => 'setAcceptUnknown',
        'element' => 'UnknownContentCode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnknownContentCode',
      ),
      'format' =>
      array (
        'setter' => 'addFormat',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'patchFormat' =>
      array (
        'setter' => 'addPatchFormat',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'implementationGuide' =>
      array (
        'setter' => 'addImplementationGuide',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'profile' =>
      array (
        'setter' => 'addProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'rest' =>
      array (
        'setter' => 'addRest',
        'element' => 'CapabilityStatement.Rest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementRest',
      ),
      'messaging' =>
      array (
        'setter' => 'addMessaging',
        'element' => 'CapabilityStatement.Messaging',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementMessaging',
      ),
      'document' =>
      array (
        'setter' => 'addDocument',
        'element' => 'CapabilityStatement.Document',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementDocument',
      ),
    ),
    ),
    'CapabilityStatement.Software' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSoftware',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'releaseDate' =>
      array (
        'setter' => 'setReleaseDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'CapabilityStatement.Implementation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementImplementation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'CapabilityStatement.Rest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementRest',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'RestfulCapabilityMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRestfulCapabilityMode',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'security' =>
      array (
        'setter' => 'setSecurity',
        'element' => 'CapabilityStatement.Security',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSecurity',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'CapabilityStatement.Resource',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementResource',
      ),
      'interaction' =>
      array (
        'setter' => 'addInteraction',
        'element' => 'CapabilityStatement.Interaction1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction1',
      ),
      'searchParam' =>
      array (
        'setter' => 'addSearchParam',
        'element' => 'CapabilityStatement.SearchParam',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam',
      ),
      'operation' =>
      array (
        'setter' => 'addOperation',
        'element' => 'CapabilityStatement.Operation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation',
      ),
      'compartment' =>
      array (
        'setter' => 'addCompartment',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'CapabilityStatement.Security' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSecurity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'cors' =>
      array (
        'setter' => 'setCors',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'service' =>
      array (
        'setter' => 'addService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'certificate' =>
      array (
        'setter' => 'addCertificate',
        'element' => 'CapabilityStatement.Certificate',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementCertificate',
      ),
    ),
    ),
    'CapabilityStatement.Certificate' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementCertificate',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'blob' =>
      array (
        'setter' => 'setBlob',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
    ),
    ),
    'CapabilityStatement.Resource' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementResource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'interaction' =>
      array (
        'setter' => 'addInteraction',
        'element' => 'CapabilityStatement.Interaction',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction',
      ),
      'versioning' =>
      array (
        'setter' => 'setVersioning',
        'element' => 'ResourceVersionPolicy',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceVersionPolicy',
      ),
      'readHistory' =>
      array (
        'setter' => 'setReadHistory',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'updateCreate' =>
      array (
        'setter' => 'setUpdateCreate',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'conditionalCreate' =>
      array (
        'setter' => 'setConditionalCreate',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'conditionalRead' =>
      array (
        'setter' => 'setConditionalRead',
        'element' => 'ConditionalReadStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionalReadStatus',
      ),
      'conditionalUpdate' =>
      array (
        'setter' => 'setConditionalUpdate',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'conditionalDelete' =>
      array (
        'setter' => 'setConditionalDelete',
        'element' => 'ConditionalDeleteStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionalDeleteStatus',
      ),
      'referencePolicy' =>
      array (
        'setter' => 'addReferencePolicy',
        'element' => 'ReferenceHandlingPolicy',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReferenceHandlingPolicy',
      ),
      'searchInclude' =>
      array (
        'setter' => 'addSearchInclude',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'searchRevInclude' =>
      array (
        'setter' => 'addSearchRevInclude',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'searchParam' =>
      array (
        'setter' => 'addSearchParam',
        'element' => 'CapabilityStatement.SearchParam',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam',
      ),
    ),
    ),
    'CapabilityStatement.Interaction' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'TypeRestfulInteraction',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTypeRestfulInteraction',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CapabilityStatement.SearchParam' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSearchParam',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'SearchParamType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchParamType',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CapabilityStatement.Interaction1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementInteraction1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'SystemRestfulInteraction',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSystemRestfulInteraction',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CapabilityStatement.Operation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementOperation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CapabilityStatement.Messaging' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementMessaging',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'CapabilityStatement.Endpoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEndpoint',
      ),
      'reliableCache' =>
      array (
        'setter' => 'setReliableCache',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'supportedMessage' =>
      array (
        'setter' => 'addSupportedMessage',
        'element' => 'CapabilityStatement.SupportedMessage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSupportedMessage',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'CapabilityStatement.Event',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEvent',
      ),
    ),
    ),
    'CapabilityStatement.Endpoint' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEndpoint',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'protocol' =>
      array (
        'setter' => 'setProtocol',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'CapabilityStatement.SupportedMessage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementSupportedMessage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'EventCapabilityMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventCapabilityMode',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CapabilityStatement.Event' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementEvent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'MessageSignificanceCategory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMessageSignificanceCategory',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'EventCapabilityMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventCapabilityMode',
      ),
      'focus' =>
      array (
        'setter' => 'setFocus',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CapabilityStatement.Document' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCapabilityStatement\\FHIRCapabilityStatementDocument',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'DocumentMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentMode',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CapabilityStatementKind' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCapabilityStatementKind',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CapabilityStatementKind-list',
        'type' => 'string',
      ),
    ),
    ),
    'EventCapabilityMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREventCapabilityMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EventCapabilityMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ResourceVersionPolicy' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceVersionPolicy',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ResourceVersionPolicy-list',
        'type' => 'string',
      ),
    ),
    ),
    'MessageSignificanceCategory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMessageSignificanceCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MessageSignificanceCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DocumentMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'RestfulCapabilityMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRestfulCapabilityMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RestfulCapabilityMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'UnknownContentCode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnknownContentCode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'UnknownContentCode-list',
        'type' => 'string',
      ),
    ),
    ),
    'TypeRestfulInteraction' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRTypeRestfulInteraction',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'TypeRestfulInteraction-list',
        'type' => 'string',
      ),
    ),
    ),
    'SystemRestfulInteraction' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSystemRestfulInteraction',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SystemRestfulInteraction-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConditionalReadStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionalReadStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConditionalReadStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ReferenceHandlingPolicy' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRReferenceHandlingPolicy',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ReferenceHandlingPolicy-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConditionalDeleteStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionalDeleteStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConditionalDeleteStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CarePlan' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCarePlan',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'replaces' =>
      array (
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CarePlanStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanStatus',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'CarePlanIntent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanIntent',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'careTeam' =>
      array (
        'setter' => 'addCareTeam',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'addresses' =>
      array (
        'setter' => 'addAddresses',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'goal' =>
      array (
        'setter' => 'addGoal',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'activity' =>
      array (
        'setter' => 'addActivity',
        'element' => 'CarePlan.Activity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanActivity',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'CarePlan.Activity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanActivity',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'outcomeCodeableConcept' =>
      array (
        'setter' => 'addOutcomeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcomeReference' =>
      array (
        'setter' => 'addOutcomeReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'progress' =>
      array (
        'setter' => 'addProgress',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'detail' =>
      array (
        'setter' => 'setDetail',
        'element' => 'CarePlan.Detail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanDetail',
      ),
    ),
    ),
    'CarePlan.Detail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCarePlan\\FHIRCarePlanDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'goal' =>
      array (
        'setter' => 'addGoal',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CarePlanActivityStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanActivityStatus',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'prohibited' =>
      array (
        'setter' => 'setProhibited',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'scheduledTiming' =>
      array (
        'setter' => 'setScheduledTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'scheduledPeriod' =>
      array (
        'setter' => 'setScheduledPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'scheduledString' =>
      array (
        'setter' => 'setScheduledString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'productCodeableConcept' =>
      array (
        'setter' => 'setProductCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productReference' =>
      array (
        'setter' => 'setProductReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'dailyAmount' =>
      array (
        'setter' => 'setDailyAmount',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CarePlanStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CarePlanStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CarePlanActivityStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanActivityStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CarePlanActivityStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CarePlanIntent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCarePlanIntent',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CarePlanIntent-list',
        'type' => 'string',
      ),
    ),
    ),
    'CareTeam' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCareTeam',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CareTeamStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCareTeamStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'CareTeam.Participant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCareTeam\\FHIRCareTeamParticipant',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'addManagingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'CareTeam.Participant' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCareTeam\\FHIRCareTeamParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'member' =>
      array (
        'setter' => 'setMember',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'CareTeamStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCareTeamStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CareTeamStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ChargeItem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRChargeItem',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ChargeItemStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRChargeItemStatus',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'occurrenceTiming' =>
      array (
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'ChargeItem.Participant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRChargeItem\\FHIRChargeItemParticipant',
      ),
      'performingOrganization' =>
      array (
        'setter' => 'setPerformingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestingOrganization' =>
      array (
        'setter' => 'setRequestingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'bodysite' =>
      array (
        'setter' => 'addBodysite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'factorOverride' =>
      array (
        'setter' => 'setFactorOverride',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'priceOverride' =>
      array (
        'setter' => 'setPriceOverride',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'overrideReason' =>
      array (
        'setter' => 'setOverrideReason',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'enteredDate' =>
      array (
        'setter' => 'setEnteredDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'addService',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'account' =>
      array (
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ChargeItem.Participant' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRChargeItem\\FHIRChargeItemParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ChargeItemStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRChargeItemStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ChargeItemStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Claim' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClaim',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'addSubType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Use',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUse',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'billablePeriod' =>
      array (
        'setter' => 'setBillablePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fundsReserve' =>
      array (
        'setter' => 'setFundsReserve',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'Claim.Related',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimRelated',
      ),
      'prescription' =>
      array (
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'originalPrescription' =>
      array (
        'setter' => 'setOriginalPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'payee' =>
      array (
        'setter' => 'setPayee',
        'element' => 'Claim.Payee',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimPayee',
      ),
      'referral' =>
      array (
        'setter' => 'setReferral',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'careTeam' =>
      array (
        'setter' => 'addCareTeam',
        'element' => 'Claim.CareTeam',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimCareTeam',
      ),
      'information' =>
      array (
        'setter' => 'addInformation',
        'element' => 'Claim.Information',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimInformation',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'Claim.Diagnosis',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimDiagnosis',
      ),
      'procedure' =>
      array (
        'setter' => 'addProcedure',
        'element' => 'Claim.Procedure',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimProcedure',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'Claim.Insurance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimInsurance',
      ),
      'accident' =>
      array (
        'setter' => 'setAccident',
        'element' => 'Claim.Accident',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimAccident',
      ),
      'employmentImpacted' =>
      array (
        'setter' => 'setEmploymentImpacted',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'hospitalization' =>
      array (
        'setter' => 'setHospitalization',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'Claim.Item',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimItem',
      ),
      'total' =>
      array (
        'setter' => 'setTotal',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
    ),
    ),
    'Claim.Related' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'Claim.Payee' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimPayee',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'resourceType' =>
      array (
        'setter' => 'setResourceType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.CareTeam' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimCareTeam',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'qualification' =>
      array (
        'setter' => 'setQualification',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Claim.Information' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimInformation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'timingDate' =>
      array (
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Claim.Diagnosis' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisCodeableConcept' =>
      array (
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosisReference' =>
      array (
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'packageCode' =>
      array (
        'setter' => 'setPackageCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Claim.Procedure' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimProcedure',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'procedureCodeableConcept' =>
      array (
        'setter' => 'setProcedureCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'procedureReference' =>
      array (
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.Insurance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'focal' =>
      array (
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'businessArrangement' =>
      array (
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'claimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.Accident' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimAccident',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Claim.Item' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'careTeamLinkId' =>
      array (
        'setter' => 'addCareTeamLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisLinkId' =>
      array (
        'setter' => 'addDiagnosisLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'procedureLinkId' =>
      array (
        'setter' => 'addProcedureLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'informationLinkId' =>
      array (
        'setter' => 'addInformationLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'locationCodeableConcept' =>
      array (
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subSite' =>
      array (
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'encounter' =>
      array (
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Claim.Detail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimDetail',
      ),
    ),
    ),
    'Claim.Detail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'Claim.SubDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimSubDetail',
      ),
    ),
    ),
    'Claim.SubDetail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaim\\FHIRClaimSubDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Use' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'Use-list',
        'type' => 'string',
      ),
    ),
    ),
    'FinancialResourceStatusCodes' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FinancialResourceStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ClaimResponse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClaimResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestProvider' =>
      array (
        'setter' => 'setRequestProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestOrganization' =>
      array (
        'setter' => 'setRequestOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'payeeType' =>
      array (
        'setter' => 'setPayeeType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'ClaimResponse.Item',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseItem',
      ),
      'addItem' =>
      array (
        'setter' => 'addAddItem',
        'element' => 'ClaimResponse.AddItem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAddItem',
      ),
      'error' =>
      array (
        'setter' => 'addError',
        'element' => 'ClaimResponse.Error',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseError',
      ),
      'totalCost' =>
      array (
        'setter' => 'setTotalCost',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'unallocDeductable' =>
      array (
        'setter' => 'setUnallocDeductable',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'totalBenefit' =>
      array (
        'setter' => 'setTotalBenefit',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'payment' =>
      array (
        'setter' => 'setPayment',
        'element' => 'ClaimResponse.Payment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponsePayment',
      ),
      'reserved' =>
      array (
        'setter' => 'setReserved',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'processNote' =>
      array (
        'setter' => 'addProcessNote',
        'element' => 'ClaimResponse.ProcessNote',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseProcessNote',
      ),
      'communicationRequest' =>
      array (
        'setter' => 'addCommunicationRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'ClaimResponse.Insurance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseInsurance',
      ),
    ),
    ),
    'ClaimResponse.Item' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequenceLinkId' =>
      array (
        'setter' => 'setSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ClaimResponse.Detail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail',
      ),
    ),
    ),
    'ClaimResponse.Adjudication' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'ClaimResponse.Detail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequenceLinkId' =>
      array (
        'setter' => 'setSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'ClaimResponse.SubDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail',
      ),
    ),
    ),
    'ClaimResponse.SubDetail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseSubDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequenceLinkId' =>
      array (
        'setter' => 'setSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
    ),
    ),
    'ClaimResponse.AddItem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAddItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequenceLinkId' =>
      array (
        'setter' => 'addSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fee' =>
      array (
        'setter' => 'setFee',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ClaimResponse.Detail1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail1',
      ),
    ),
    ),
    'ClaimResponse.Detail1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseDetail1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fee' =>
      array (
        'setter' => 'setFee',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ClaimResponse.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseAdjudication',
      ),
    ),
    ),
    'ClaimResponse.Error' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseError',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequenceLinkId' =>
      array (
        'setter' => 'setSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'detailSequenceLinkId' =>
      array (
        'setter' => 'setDetailSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'subdetailSequenceLinkId' =>
      array (
        'setter' => 'setSubdetailSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ClaimResponse.Payment' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponsePayment',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'adjustment' =>
      array (
        'setter' => 'setAdjustment',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'adjustmentReason' =>
      array (
        'setter' => 'setAdjustmentReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'ClaimResponse.ProcessNote' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseProcessNote',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ClaimResponse.Insurance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClaimResponse\\FHIRClaimResponseInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'focal' =>
      array (
        'setter' => 'setFocal',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'businessArrangement' =>
      array (
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'claimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ClinicalImpression' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRClinicalImpression',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ClinicalImpressionStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRClinicalImpressionStatus',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'assessor' =>
      array (
        'setter' => 'setAssessor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'previous' =>
      array (
        'setter' => 'setPrevious',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'problem' =>
      array (
        'setter' => 'addProblem',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'investigation' =>
      array (
        'setter' => 'addInvestigation',
        'element' => 'ClinicalImpression.Investigation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionInvestigation',
      ),
      'protocol' =>
      array (
        'setter' => 'addProtocol',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'summary' =>
      array (
        'setter' => 'setSummary',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'finding' =>
      array (
        'setter' => 'addFinding',
        'element' => 'ClinicalImpression.Finding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionFinding',
      ),
      'prognosisCodeableConcept' =>
      array (
        'setter' => 'addPrognosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'prognosisReference' =>
      array (
        'setter' => 'addPrognosisReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'ClinicalImpression.Investigation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionInvestigation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ClinicalImpression.Finding' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRClinicalImpression\\FHIRClinicalImpressionFinding',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'itemCodeableConcept' =>
      array (
        'setter' => 'setItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'itemReference' =>
      array (
        'setter' => 'setItemReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'basis' =>
      array (
        'setter' => 'setBasis',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ClinicalImpressionStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRClinicalImpressionStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ClinicalImpressionStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CodeSystem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCodeSystem',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'caseSensitive' =>
      array (
        'setter' => 'setCaseSensitive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueSet' =>
      array (
        'setter' => 'setValueSet',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'hierarchyMeaning' =>
      array (
        'setter' => 'setHierarchyMeaning',
        'element' => 'CodeSystemHierarchyMeaning',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeSystemHierarchyMeaning',
      ),
      'compositional' =>
      array (
        'setter' => 'setCompositional',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'versionNeeded' =>
      array (
        'setter' => 'setVersionNeeded',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'content' =>
      array (
        'setter' => 'setContent',
        'element' => 'CodeSystemContentMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeSystemContentMode',
      ),
      'count' =>
      array (
        'setter' => 'setCount',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'filter' =>
      array (
        'setter' => 'addFilter',
        'element' => 'CodeSystem.Filter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemFilter',
      ),
      'property' =>
      array (
        'setter' => 'addProperty',
        'element' => 'CodeSystem.Property',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty',
      ),
      'concept' =>
      array (
        'setter' => 'addConcept',
        'element' => 'CodeSystem.Concept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept',
      ),
    ),
    ),
    'CodeSystem.Filter' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemFilter',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'operator' =>
      array (
        'setter' => 'addOperator',
        'element' => 'FilterOperator',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFilterOperator',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CodeSystem.Property' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'PropertyType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPropertyType',
      ),
    ),
    ),
    'CodeSystem.Concept' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'setDefinition',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'designation' =>
      array (
        'setter' => 'addDesignation',
        'element' => 'CodeSystem.Designation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemDesignation',
      ),
      'property' =>
      array (
        'setter' => 'addProperty',
        'element' => 'CodeSystem.Property1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty1',
      ),
      'concept' =>
      array (
        'setter' => 'addConcept',
        'element' => 'CodeSystem.Concept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemConcept',
      ),
    ),
    ),
    'CodeSystem.Designation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemDesignation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CodeSystem.Property1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCodeSystem\\FHIRCodeSystemProperty1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'FilterOperator' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRFilterOperator',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FilterOperator-list',
        'type' => 'string',
      ),
    ),
    ),
    'PropertyType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRPropertyType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'PropertyType-list',
        'type' => 'string',
      ),
    ),
    ),
    'CodeSystemHierarchyMeaning' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeSystemHierarchyMeaning',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CodeSystemHierarchyMeaning-list',
        'type' => 'string',
      ),
    ),
    ),
    'CodeSystemContentMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeSystemContentMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CodeSystemContentMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'Communication' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCommunication',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EventStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREventStatus',
      ),
      'notDone' =>
      array (
        'setter' => 'setNotDone',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'notDoneReason' =>
      array (
        'setter' => 'setNotDoneReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medium' =>
      array (
        'setter' => 'addMedium',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'sent' =>
      array (
        'setter' => 'setSent',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'received' =>
      array (
        'setter' => 'setReceived',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'sender' =>
      array (
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'payload' =>
      array (
        'setter' => 'addPayload',
        'element' => 'Communication.Payload',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunication\\FHIRCommunicationPayload',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'Communication.Payload' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunication\\FHIRCommunicationPayload',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'contentString' =>
      array (
        'setter' => 'setContentString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EventStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREventStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EventStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'CommunicationRequest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCommunicationRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'replaces' =>
      array (
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'groupIdentifier' =>
      array (
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestPriority',
      ),
      'medium' =>
      array (
        'setter' => 'addMedium',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'payload' =>
      array (
        'setter' => 'addPayload',
        'element' => 'CommunicationRequest.Payload',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestPayload',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'authoredOn' =>
      array (
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'sender' =>
      array (
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requester' =>
      array (
        'setter' => 'setRequester',
        'element' => 'CommunicationRequest.Requester',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestRequester',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'CommunicationRequest.Payload' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestPayload',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'contentString' =>
      array (
        'setter' => 'setContentString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'CommunicationRequest.Requester' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCommunicationRequest\\FHIRCommunicationRequestRequester',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'agent' =>
      array (
        'setter' => 'setAgent',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'RequestStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RequestStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'RequestPriority' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestPriority',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'RequestPriority-list',
        'type' => 'string',
      ),
    ),
    ),
    'CompartmentDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCompartmentDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CompartmentType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompartmentType',
      ),
      'search' =>
      array (
        'setter' => 'setSearch',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'CompartmentDefinition.Resource',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCompartmentDefinition\\FHIRCompartmentDefinitionResource',
      ),
    ),
    ),
    'CompartmentDefinition.Resource' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCompartmentDefinition\\FHIRCompartmentDefinitionResource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'param' =>
      array (
        'setter' => 'addParam',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'CompartmentType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompartmentType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CompartmentType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Composition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRComposition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'CompositionStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'confidentiality' =>
      array (
        'setter' => 'setConfidentiality',
        'element' => 'ConfidentialityClassification',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConfidentialityClassification',
      ),
      'attester' =>
      array (
        'setter' => 'addAttester',
        'element' => 'Composition.Attester',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionAttester',
      ),
      'custodian' =>
      array (
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'relatesTo' =>
      array (
        'setter' => 'addRelatesTo',
        'element' => 'Composition.RelatesTo',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionRelatesTo',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'Composition.Event',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionEvent',
      ),
      'section' =>
      array (
        'setter' => 'addSection',
        'element' => 'Composition.Section',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionSection',
      ),
    ),
    ),
    'Composition.Attester' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionAttester',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'addMode',
        'element' => 'CompositionAttestationMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionAttestationMode',
      ),
      'time' =>
      array (
        'setter' => 'setTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Composition.RelatesTo' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionRelatesTo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'DocumentRelationshipType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentRelationshipType',
      ),
      'targetIdentifier' =>
      array (
        'setter' => 'setTargetIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'targetReference' =>
      array (
        'setter' => 'setTargetReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Composition.Event' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionEvent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Composition.Section' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionSection',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'ListMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRListMode',
      ),
      'orderedBy' =>
      array (
        'setter' => 'setOrderedBy',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'entry' =>
      array (
        'setter' => 'addEntry',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'emptyReason' =>
      array (
        'setter' => 'setEmptyReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'section' =>
      array (
        'setter' => 'addSection',
        'element' => 'Composition.Section',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRComposition\\FHIRCompositionSection',
      ),
    ),
    ),
    'CompositionStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CompositionStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConfidentialityClassification' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConfidentialityClassification',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConfidentialityClassification-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentRelationshipType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentRelationshipType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DocumentRelationshipType-list',
        'type' => 'string',
      ),
    ),
    ),
    'CompositionAttestationMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionAttestationMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'CompositionAttestationMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ListMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRListMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ListMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConceptMap' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRConceptMap',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'sourceUri' =>
      array (
        'setter' => 'setSourceUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'sourceReference' =>
      array (
        'setter' => 'setSourceReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'targetUri' =>
      array (
        'setter' => 'setTargetUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'targetReference' =>
      array (
        'setter' => 'setTargetReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'group' =>
      array (
        'setter' => 'addGroup',
        'element' => 'ConceptMap.Group',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapGroup',
      ),
    ),
    ),
    'ConceptMap.Group' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapGroup',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'sourceVersion' =>
      array (
        'setter' => 'setSourceVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'targetVersion' =>
      array (
        'setter' => 'setTargetVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'element' =>
      array (
        'setter' => 'addElement',
        'element' => 'ConceptMap.Element',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapElement',
      ),
      'unmapped' =>
      array (
        'setter' => 'setUnmapped',
        'element' => 'ConceptMap.Unmapped',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapUnmapped',
      ),
    ),
    ),
    'ConceptMap.Element' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapElement',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'addTarget',
        'element' => 'ConceptMap.Target',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapTarget',
      ),
    ),
    ),
    'ConceptMap.Target' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapTarget',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'equivalence' =>
      array (
        'setter' => 'setEquivalence',
        'element' => 'ConceptMapEquivalence',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConceptMapEquivalence',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'dependsOn' =>
      array (
        'setter' => 'addDependsOn',
        'element' => 'ConceptMap.DependsOn',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn',
      ),
      'product' =>
      array (
        'setter' => 'addProduct',
        'element' => 'ConceptMap.DependsOn',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn',
      ),
    ),
    ),
    'ConceptMap.DependsOn' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapDependsOn',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'property' =>
      array (
        'setter' => 'setProperty',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ConceptMap.Unmapped' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConceptMap\\FHIRConceptMapUnmapped',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'ConceptMapGroupUnmappedMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConceptMapGroupUnmappedMode',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'display' =>
      array (
        'setter' => 'setDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'ConceptMapGroupUnmappedMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConceptMapGroupUnmappedMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConceptMapGroupUnmappedMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'Condition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCondition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'clinicalStatus' =>
      array (
        'setter' => 'setClinicalStatus',
        'element' => 'ConditionClinicalStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionClinicalStatusCodes',
      ),
      'verificationStatus' =>
      array (
        'setter' => 'setVerificationStatus',
        'element' => 'ConditionVerificationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionVerificationStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'bodySite' =>
      array (
        'setter' => 'addBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onsetDateTime' =>
      array (
        'setter' => 'setOnsetDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'onsetAge' =>
      array (
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'onsetPeriod' =>
      array (
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'onsetRange' =>
      array (
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'onsetString' =>
      array (
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'abatementDateTime' =>
      array (
        'setter' => 'setAbatementDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'abatementAge' =>
      array (
        'setter' => 'setAbatementAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'abatementBoolean' =>
      array (
        'setter' => 'setAbatementBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'abatementPeriod' =>
      array (
        'setter' => 'setAbatementPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'abatementRange' =>
      array (
        'setter' => 'setAbatementRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'abatementString' =>
      array (
        'setter' => 'setAbatementString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'assertedDate' =>
      array (
        'setter' => 'setAssertedDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'asserter' =>
      array (
        'setter' => 'setAsserter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'stage' =>
      array (
        'setter' => 'setStage',
        'element' => 'Condition.Stage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCondition\\FHIRConditionStage',
      ),
      'evidence' =>
      array (
        'setter' => 'addEvidence',
        'element' => 'Condition.Evidence',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCondition\\FHIRConditionEvidence',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'Condition.Stage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCondition\\FHIRConditionStage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'summary' =>
      array (
        'setter' => 'setSummary',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'assessment' =>
      array (
        'setter' => 'addAssessment',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Condition.Evidence' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCondition\\FHIRConditionEvidence',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ConditionVerificationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionVerificationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConditionVerificationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConditionClinicalStatusCodes' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConditionClinicalStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConditionClinicalStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'Consent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRConsent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ConsentState',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentState',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'dateTime' =>
      array (
        'setter' => 'setDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'consentingParty' =>
      array (
        'setter' => 'addConsentingParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'actor' =>
      array (
        'setter' => 'addActor',
        'element' => 'Consent.Actor',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentActor',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'organization' =>
      array (
        'setter' => 'addOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'sourceAttachment' =>
      array (
        'setter' => 'setSourceAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'sourceIdentifier' =>
      array (
        'setter' => 'setSourceIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'sourceReference' =>
      array (
        'setter' => 'setSourceReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'policy' =>
      array (
        'setter' => 'addPolicy',
        'element' => 'Consent.Policy',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentPolicy',
      ),
      'policyRule' =>
      array (
        'setter' => 'setPolicyRule',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'purpose' =>
      array (
        'setter' => 'addPurpose',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'dataPeriod' =>
      array (
        'setter' => 'setDataPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'data' =>
      array (
        'setter' => 'addData',
        'element' => 'Consent.Data',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentData',
      ),
      'except' =>
      array (
        'setter' => 'addExcept',
        'element' => 'Consent.Except',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentExcept',
      ),
    ),
    ),
    'Consent.Actor' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentActor',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Consent.Policy' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentPolicy',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'Consent.Data' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentData',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'meaning' =>
      array (
        'setter' => 'setMeaning',
        'element' => 'ConsentDataMeaning',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentDataMeaning',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Consent.Except' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentExcept',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ConsentExceptType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentExceptType',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'actor' =>
      array (
        'setter' => 'addActor',
        'element' => 'Consent.Actor1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentActor1',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'purpose' =>
      array (
        'setter' => 'addPurpose',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'class' =>
      array (
        'setter' => 'addClass',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'code' =>
      array (
        'setter' => 'addCode',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'dataPeriod' =>
      array (
        'setter' => 'setDataPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'data' =>
      array (
        'setter' => 'addData',
        'element' => 'Consent.Data1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentData1',
      ),
    ),
    ),
    'Consent.Actor1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentActor1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Consent.Data1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRConsent\\FHIRConsentData1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'meaning' =>
      array (
        'setter' => 'setMeaning',
        'element' => 'ConsentDataMeaning',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentDataMeaning',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ConsentDataMeaning' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentDataMeaning',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConsentDataMeaning-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConsentState' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentState',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConsentState-list',
        'type' => 'string',
      ),
    ),
    ),
    'ConsentExceptType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRConsentExceptType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ConsentExceptType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Contract' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRContract',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ContractResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContractResourceStatusCodes',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'applies' =>
      array (
        'setter' => 'setApplies',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'subject' =>
      array (
        'setter' => 'addSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'authority' =>
      array (
        'setter' => 'addAuthority',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'domain' =>
      array (
        'setter' => 'addDomain',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'addSubType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actionReason' =>
      array (
        'setter' => 'addActionReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'decisionType' =>
      array (
        'setter' => 'setDecisionType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contentDerivative' =>
      array (
        'setter' => 'setContentDerivative',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'agent' =>
      array (
        'setter' => 'addAgent',
        'element' => 'Contract.Agent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractAgent',
      ),
      'signer' =>
      array (
        'setter' => 'addSigner',
        'element' => 'Contract.Signer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractSigner',
      ),
      'valuedItem' =>
      array (
        'setter' => 'addValuedItem',
        'element' => 'Contract.ValuedItem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractValuedItem',
      ),
      'term' =>
      array (
        'setter' => 'addTerm',
        'element' => 'Contract.Term',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractTerm',
      ),
      'bindingAttachment' =>
      array (
        'setter' => 'setBindingAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'bindingReference' =>
      array (
        'setter' => 'setBindingReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'friendly' =>
      array (
        'setter' => 'addFriendly',
        'element' => 'Contract.Friendly',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractFriendly',
      ),
      'legal' =>
      array (
        'setter' => 'addLegal',
        'element' => 'Contract.Legal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractLegal',
      ),
      'rule' =>
      array (
        'setter' => 'addRule',
        'element' => 'Contract.Rule',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractRule',
      ),
    ),
    ),
    'Contract.Agent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractAgent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Contract.Signer' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractSigner',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'signature' =>
      array (
        'setter' => 'addSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
    ),
    ),
    'Contract.ValuedItem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractValuedItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'entityCodeableConcept' =>
      array (
        'setter' => 'setEntityCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'entityReference' =>
      array (
        'setter' => 'setEntityReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'effectiveTime' =>
      array (
        'setter' => 'setEffectiveTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'points' =>
      array (
        'setter' => 'setPoints',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
    ),
    ),
    'Contract.Term' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractTerm',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'applies' =>
      array (
        'setter' => 'setApplies',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'setSubType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'action' =>
      array (
        'setter' => 'addAction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actionReason' =>
      array (
        'setter' => 'addActionReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'agent' =>
      array (
        'setter' => 'addAgent',
        'element' => 'Contract.Agent1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractAgent1',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valuedItem' =>
      array (
        'setter' => 'addValuedItem',
        'element' => 'Contract.ValuedItem1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractValuedItem1',
      ),
      'group' =>
      array (
        'setter' => 'addGroup',
        'element' => 'Contract.Term',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractTerm',
      ),
    ),
    ),
    'Contract.Agent1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractAgent1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'addRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Contract.ValuedItem1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractValuedItem1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'entityCodeableConcept' =>
      array (
        'setter' => 'setEntityCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'entityReference' =>
      array (
        'setter' => 'setEntityReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'effectiveTime' =>
      array (
        'setter' => 'setEffectiveTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'points' =>
      array (
        'setter' => 'setPoints',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
    ),
    ),
    'Contract.Friendly' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractFriendly',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Contract.Legal' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractLegal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Contract.Rule' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRContract\\FHIRContractRule',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'contentAttachment' =>
      array (
        'setter' => 'setContentAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'contentReference' =>
      array (
        'setter' => 'setContentReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ContractResourceStatusCodes' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRContractResourceStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ContractResourceStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'Coverage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRCoverage',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'policyHolder' =>
      array (
        'setter' => 'setPolicyHolder',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subscriber' =>
      array (
        'setter' => 'setSubscriber',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subscriberId' =>
      array (
        'setter' => 'setSubscriberId',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'beneficiary' =>
      array (
        'setter' => 'setBeneficiary',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'payor' =>
      array (
        'setter' => 'addPayor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'grouping' =>
      array (
        'setter' => 'setGrouping',
        'element' => 'Coverage.Grouping',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRCoverage\\FHIRCoverageGrouping',
      ),
      'dependent' =>
      array (
        'setter' => 'setDependent',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'order' =>
      array (
        'setter' => 'setOrder',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contract' =>
      array (
        'setter' => 'addContract',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Coverage.Grouping' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRCoverage\\FHIRCoverageGrouping',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'group' =>
      array (
        'setter' => 'setGroup',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'groupDisplay' =>
      array (
        'setter' => 'setGroupDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subGroup' =>
      array (
        'setter' => 'setSubGroup',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subGroupDisplay' =>
      array (
        'setter' => 'setSubGroupDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'plan' =>
      array (
        'setter' => 'setPlan',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'planDisplay' =>
      array (
        'setter' => 'setPlanDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subPlan' =>
      array (
        'setter' => 'setSubPlan',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subPlanDisplay' =>
      array (
        'setter' => 'setSubPlanDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'classDisplay' =>
      array (
        'setter' => 'setClassDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subClass' =>
      array (
        'setter' => 'setSubClass',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'subClassDisplay' =>
      array (
        'setter' => 'setSubClassDisplay',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'DataElement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDataElement',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'stringency' =>
      array (
        'setter' => 'setStringency',
        'element' => 'DataElementStringency',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataElementStringency',
      ),
      'mapping' =>
      array (
        'setter' => 'addMapping',
        'element' => 'DataElement.Mapping',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataElement\\FHIRDataElementMapping',
      ),
      'element' =>
      array (
        'setter' => 'addElement',
        'element' => 'ElementDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRElementDefinition',
      ),
    ),
    ),
    'DataElement.Mapping' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDataElement\\FHIRDataElementMapping',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identity' =>
      array (
        'setter' => 'setIdentity',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'DataElementStringency' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataElementStringency',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DataElementStringency-list',
        'type' => 'string',
      ),
    ),
    ),
    'DetectedIssue' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDetectedIssue',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ObservationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationStatus',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'DetectedIssueSeverity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDetectedIssueSeverity',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'implicated' =>
      array (
        'setter' => 'addImplicated',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'detail' =>
      array (
        'setter' => 'setDetail',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'mitigation' =>
      array (
        'setter' => 'addMitigation',
        'element' => 'DetectedIssue.Mitigation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueMitigation',
      ),
    ),
    ),
    'DetectedIssue.Mitigation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDetectedIssue\\FHIRDetectedIssueMitigation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'action' =>
      array (
        'setter' => 'setAction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ObservationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ObservationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DetectedIssueSeverity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDetectedIssueSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DetectedIssueSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'Device' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDevice',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'udi' =>
      array (
        'setter' => 'setUdi',
        'element' => 'Device.Udi',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDevice\\FHIRDeviceUdi',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FHIRDeviceStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRDeviceStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'lotNumber' =>
      array (
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'manufacturer' =>
      array (
        'setter' => 'setManufacturer',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'manufactureDate' =>
      array (
        'setter' => 'setManufactureDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'expirationDate' =>
      array (
        'setter' => 'setExpirationDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'model' =>
      array (
        'setter' => 'setModel',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'owner' =>
      array (
        'setter' => 'setOwner',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'safety' =>
      array (
        'setter' => 'addSafety',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Device.Udi' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDevice\\FHIRDeviceUdi',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'deviceIdentifier' =>
      array (
        'setter' => 'setDeviceIdentifier',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'setJurisdiction',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'carrierHRF' =>
      array (
        'setter' => 'setCarrierHRF',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'carrierAIDC' =>
      array (
        'setter' => 'setCarrierAIDC',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'issuer' =>
      array (
        'setter' => 'setIssuer',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'entryType' =>
      array (
        'setter' => 'setEntryType',
        'element' => 'UDIEntryType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUDIEntryType',
      ),
    ),
    ),
    'FHIRDeviceStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRDeviceStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FHIRDeviceStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'UDIEntryType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRUDIEntryType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'UDIEntryType-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceComponent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceComponent',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'lastSystemChange' =>
      array (
        'setter' => 'setLastSystemChange',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'parent' =>
      array (
        'setter' => 'setParent',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'operationalStatus' =>
      array (
        'setter' => 'addOperationalStatus',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'parameterGroup' =>
      array (
        'setter' => 'setParameterGroup',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'measurementPrinciple' =>
      array (
        'setter' => 'setMeasurementPrinciple',
        'element' => 'MeasmntPrinciple',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasmntPrinciple',
      ),
      'productionSpecification' =>
      array (
        'setter' => 'addProductionSpecification',
        'element' => 'DeviceComponent.ProductionSpecification',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceComponent\\FHIRDeviceComponentProductionSpecification',
      ),
      'languageCode' =>
      array (
        'setter' => 'setLanguageCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'DeviceComponent.ProductionSpecification' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceComponent\\FHIRDeviceComponentProductionSpecification',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'specType' =>
      array (
        'setter' => 'setSpecType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'componentId' =>
      array (
        'setter' => 'setComponentId',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'productionSpec' =>
      array (
        'setter' => 'setProductionSpec',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'MeasmntPrinciple' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasmntPrinciple',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MeasmntPrinciple-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetric' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceMetric',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'parent' =>
      array (
        'setter' => 'setParent',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'operationalStatus' =>
      array (
        'setter' => 'setOperationalStatus',
        'element' => 'DeviceMetricOperationalStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricOperationalStatus',
      ),
      'color' =>
      array (
        'setter' => 'setColor',
        'element' => 'DeviceMetricColor',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricColor',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'DeviceMetricCategory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCategory',
      ),
      'measurementPeriod' =>
      array (
        'setter' => 'setMeasurementPeriod',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'calibration' =>
      array (
        'setter' => 'addCalibration',
        'element' => 'DeviceMetric.Calibration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceMetric\\FHIRDeviceMetricCalibration',
      ),
    ),
    ),
    'DeviceMetric.Calibration' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceMetric\\FHIRDeviceMetricCalibration',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DeviceMetricCalibrationType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCalibrationType',
      ),
      'state' =>
      array (
        'setter' => 'setState',
        'element' => 'DeviceMetricCalibrationState',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCalibrationState',
      ),
      'time' =>
      array (
        'setter' => 'setTime',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
    ),
    ),
    'DeviceMetricCalibrationType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCalibrationType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricCalibrationType-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricColor' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricColor',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricColor-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricCalibrationState' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCalibrationState',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricCalibrationState-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricOperationalStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricOperationalStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricOperationalStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceMetricCategory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceMetricCategory',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceMetricCategory-list',
        'type' => 'string',
      ),
    ),
    ),
    'DeviceRequest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'priorRequest' =>
      array (
        'setter' => 'addPriorRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'groupIdentifier' =>
      array (
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'RequestStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestStatus',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'RequestPriority',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRequestPriority',
      ),
      'codeReference' =>
      array (
        'setter' => 'setCodeReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'codeCodeableConcept' =>
      array (
        'setter' => 'setCodeCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'occurrenceTiming' =>
      array (
        'setter' => 'setOccurrenceTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'authoredOn' =>
      array (
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'requester' =>
      array (
        'setter' => 'setRequester',
        'element' => 'DeviceRequest.Requester',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceRequest\\FHIRDeviceRequestRequester',
      ),
      'performerType' =>
      array (
        'setter' => 'setPerformerType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'performer' =>
      array (
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'supportingInfo' =>
      array (
        'setter' => 'addSupportingInfo',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'relevantHistory' =>
      array (
        'setter' => 'addRelevantHistory',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DeviceRequest.Requester' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDeviceRequest\\FHIRDeviceRequestRequester',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'agent' =>
      array (
        'setter' => 'setAgent',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DeviceUseStatement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDeviceUseStatement',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DeviceUseStatementStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceUseStatementStatus',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'whenUsed' =>
      array (
        'setter' => 'setWhenUsed',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'timingTiming' =>
      array (
        'setter' => 'setTimingTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'timingDateTime' =>
      array (
        'setter' => 'setTimingDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'recordedOn' =>
      array (
        'setter' => 'setRecordedOn',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'device' =>
      array (
        'setter' => 'setDevice',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'indication' =>
      array (
        'setter' => 'addIndication',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'DeviceUseStatementStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDeviceUseStatementStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DeviceUseStatementStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DiagnosticReport' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDiagnosticReport',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DiagnosticReportStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDiagnosticReportStatus',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'DiagnosticReport.Performer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportPerformer',
      ),
      'specimen' =>
      array (
        'setter' => 'addSpecimen',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'result' =>
      array (
        'setter' => 'addResult',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'imagingStudy' =>
      array (
        'setter' => 'addImagingStudy',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'image' =>
      array (
        'setter' => 'addImage',
        'element' => 'DiagnosticReport.Image',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportImage',
      ),
      'conclusion' =>
      array (
        'setter' => 'setConclusion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'codedDiagnosis' =>
      array (
        'setter' => 'addCodedDiagnosis',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'presentedForm' =>
      array (
        'setter' => 'addPresentedForm',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
    ),
    ),
    'DiagnosticReport.Performer' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportPerformer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DiagnosticReport.Image' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDiagnosticReport\\FHIRDiagnosticReportImage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'link' =>
      array (
        'setter' => 'setLink',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DiagnosticReportStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDiagnosticReportStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DiagnosticReportStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'DocumentManifest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDocumentManifest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'masterIdentifier' =>
      array (
        'setter' => 'setMasterIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DocumentReferenceStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentReferenceStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'recipient' =>
      array (
        'setter' => 'addRecipient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'content' =>
      array (
        'setter' => 'addContent',
        'element' => 'DocumentManifest.Content',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestContent',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'DocumentManifest.Related',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestRelated',
      ),
    ),
    ),
    'DocumentManifest.Content' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestContent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'pAttachment' =>
      array (
        'setter' => 'setPAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'pReference' =>
      array (
        'setter' => 'setPReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DocumentManifest.Related' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentManifest\\FHIRDocumentManifestRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'ref' =>
      array (
        'setter' => 'setRef',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DocumentReference' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRDocumentReference',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'masterIdentifier' =>
      array (
        'setter' => 'setMasterIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'DocumentReferenceStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentReferenceStatus',
      ),
      'docStatus' =>
      array (
        'setter' => 'setDocStatus',
        'element' => 'CompositionStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompositionStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'indexed' =>
      array (
        'setter' => 'setIndexed',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'author' =>
      array (
        'setter' => 'addAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'authenticator' =>
      array (
        'setter' => 'setAuthenticator',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'custodian' =>
      array (
        'setter' => 'setCustodian',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'relatesTo' =>
      array (
        'setter' => 'addRelatesTo',
        'element' => 'DocumentReference.RelatesTo',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelatesTo',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'securityLabel' =>
      array (
        'setter' => 'addSecurityLabel',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'content' =>
      array (
        'setter' => 'addContent',
        'element' => 'DocumentReference.Content',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContent',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'DocumentReference.Context',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContext',
      ),
    ),
    ),
    'DocumentReference.RelatesTo' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelatesTo',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'DocumentRelationshipType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDocumentRelationshipType',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'DocumentReference.Content' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'attachment' =>
      array (
        'setter' => 'setAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'format' =>
      array (
        'setter' => 'setFormat',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'DocumentReference.Context' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceContext',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'event' =>
      array (
        'setter' => 'addEvent',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'facilityType' =>
      array (
        'setter' => 'setFacilityType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'practiceSetting' =>
      array (
        'setter' => 'setPracticeSetting',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'sourcePatientInfo' =>
      array (
        'setter' => 'setSourcePatientInfo',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'DocumentReference.Related',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelated',
      ),
    ),
    ),
    'DocumentReference.Related' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRDocumentReference\\FHIRDocumentReferenceRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'ref' =>
      array (
        'setter' => 'setRef',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EligibilityRequest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREligibilityRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'businessArrangement' =>
      array (
        'setter' => 'setBusinessArrangement',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'benefitCategory' =>
      array (
        'setter' => 'setBenefitCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'benefitSubCategory' =>
      array (
        'setter' => 'setBenefitSubCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'EligibilityResponse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREligibilityResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'requestProvider' =>
      array (
        'setter' => 'setRequestProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestOrganization' =>
      array (
        'setter' => 'setRequestOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'inforce' =>
      array (
        'setter' => 'setInforce',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'insurance' =>
      array (
        'setter' => 'addInsurance',
        'element' => 'EligibilityResponse.Insurance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseInsurance',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'error' =>
      array (
        'setter' => 'addError',
        'element' => 'EligibilityResponse.Error',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseError',
      ),
    ),
    ),
    'EligibilityResponse.Insurance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'contract' =>
      array (
        'setter' => 'setContract',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'benefitBalance' =>
      array (
        'setter' => 'addBenefitBalance',
        'element' => 'EligibilityResponse.BenefitBalance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseBenefitBalance',
      ),
    ),
    ),
    'EligibilityResponse.BenefitBalance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseBenefitBalance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subCategory' =>
      array (
        'setter' => 'setSubCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'excluded' =>
      array (
        'setter' => 'setExcluded',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'term' =>
      array (
        'setter' => 'setTerm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'financial' =>
      array (
        'setter' => 'addFinancial',
        'element' => 'EligibilityResponse.Financial',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseFinancial',
      ),
    ),
    ),
    'EligibilityResponse.Financial' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseFinancial',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'allowedUnsignedInt' =>
      array (
        'setter' => 'setAllowedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'allowedString' =>
      array (
        'setter' => 'setAllowedString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'allowedMoney' =>
      array (
        'setter' => 'setAllowedMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'usedUnsignedInt' =>
      array (
        'setter' => 'setUsedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'usedMoney' =>
      array (
        'setter' => 'setUsedMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
    ),
    ),
    'EligibilityResponse.Error' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREligibilityResponse\\FHIREligibilityResponseError',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Encounter' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREncounter',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EncounterStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterStatus',
      ),
      'statusHistory' =>
      array (
        'setter' => 'addStatusHistory',
        'element' => 'Encounter.StatusHistory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterStatusHistory',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'classHistory' =>
      array (
        'setter' => 'addClassHistory',
        'element' => 'Encounter.ClassHistory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterClassHistory',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'episodeOfCare' =>
      array (
        'setter' => 'addEpisodeOfCare',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'incomingReferral' =>
      array (
        'setter' => 'addIncomingReferral',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'participant' =>
      array (
        'setter' => 'addParticipant',
        'element' => 'Encounter.Participant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterParticipant',
      ),
      'appointment' =>
      array (
        'setter' => 'setAppointment',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'length' =>
      array (
        'setter' => 'setLength',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'Encounter.Diagnosis',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterDiagnosis',
      ),
      'account' =>
      array (
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'hospitalization' =>
      array (
        'setter' => 'setHospitalization',
        'element' => 'Encounter.Hospitalization',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterHospitalization',
      ),
      'location' =>
      array (
        'setter' => 'addLocation',
        'element' => 'Encounter.Location',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterLocation',
      ),
      'serviceProvider' =>
      array (
        'setter' => 'setServiceProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Encounter.StatusHistory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterStatusHistory',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EncounterStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterStatus',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Encounter.ClassHistory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterClassHistory',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'class' =>
      array (
        'setter' => 'setClass',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Encounter.Participant' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterParticipant',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'individual' =>
      array (
        'setter' => 'setIndividual',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Encounter.Diagnosis' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'rank' =>
      array (
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
    ),
    ),
    'Encounter.Hospitalization' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterHospitalization',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'preAdmissionIdentifier' =>
      array (
        'setter' => 'setPreAdmissionIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'origin' =>
      array (
        'setter' => 'setOrigin',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'admitSource' =>
      array (
        'setter' => 'setAdmitSource',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reAdmission' =>
      array (
        'setter' => 'setReAdmission',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dietPreference' =>
      array (
        'setter' => 'addDietPreference',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialCourtesy' =>
      array (
        'setter' => 'addSpecialCourtesy',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialArrangement' =>
      array (
        'setter' => 'addSpecialArrangement',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'destination' =>
      array (
        'setter' => 'setDestination',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'dischargeDisposition' =>
      array (
        'setter' => 'setDischargeDisposition',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Encounter.Location' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREncounter\\FHIREncounterLocation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EncounterLocationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterLocationStatus',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'EncounterLocationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterLocationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EncounterLocationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'EncounterStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREncounterStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EncounterStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Endpoint' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREndpoint',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EndpointStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREndpointStatus',
      ),
      'connectionType' =>
      array (
        'setter' => 'setConnectionType',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'payloadType' =>
      array (
        'setter' => 'addPayloadType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'payloadMimeType' =>
      array (
        'setter' => 'addPayloadMimeType',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'header' =>
      array (
        'setter' => 'addHeader',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'EndpointStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREndpointStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EndpointStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'EnrollmentRequest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREnrollmentRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EnrollmentResponse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREnrollmentResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestProvider' =>
      array (
        'setter' => 'setRequestProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestOrganization' =>
      array (
        'setter' => 'setRequestOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EpisodeOfCare' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIREpisodeOfCare',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EpisodeOfCareStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREpisodeOfCareStatus',
      ),
      'statusHistory' =>
      array (
        'setter' => 'addStatusHistory',
        'element' => 'EpisodeOfCare.StatusHistory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareStatusHistory',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'EpisodeOfCare.Diagnosis',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareDiagnosis',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'referralRequest' =>
      array (
        'setter' => 'addReferralRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'careManager' =>
      array (
        'setter' => 'setCareManager',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'team' =>
      array (
        'setter' => 'addTeam',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'account' =>
      array (
        'setter' => 'addAccount',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'EpisodeOfCare.StatusHistory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareStatusHistory',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'EpisodeOfCareStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIREpisodeOfCareStatus',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'EpisodeOfCare.Diagnosis' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIREpisodeOfCare\\FHIREpisodeOfCareDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'condition' =>
      array (
        'setter' => 'setCondition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'rank' =>
      array (
        'setter' => 'setRank',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
    ),
    ),
    'EpisodeOfCareStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIREpisodeOfCareStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'EpisodeOfCareStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'ExpansionProfile' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRExpansionProfile',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fixedVersion' =>
      array (
        'setter' => 'addFixedVersion',
        'element' => 'ExpansionProfile.FixedVersion',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileFixedVersion',
      ),
      'excludedSystem' =>
      array (
        'setter' => 'setExcludedSystem',
        'element' => 'ExpansionProfile.ExcludedSystem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileExcludedSystem',
      ),
      'includeDesignations' =>
      array (
        'setter' => 'setIncludeDesignations',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'designation' =>
      array (
        'setter' => 'setDesignation',
        'element' => 'ExpansionProfile.Designation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation',
      ),
      'includeDefinition' =>
      array (
        'setter' => 'setIncludeDefinition',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'activeOnly' =>
      array (
        'setter' => 'setActiveOnly',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'excludeNested' =>
      array (
        'setter' => 'setExcludeNested',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'excludeNotForUI' =>
      array (
        'setter' => 'setExcludeNotForUI',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'excludePostCoordinated' =>
      array (
        'setter' => 'setExcludePostCoordinated',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'displayLanguage' =>
      array (
        'setter' => 'setDisplayLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'limitedExpansion' =>
      array (
        'setter' => 'setLimitedExpansion',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'ExpansionProfile.FixedVersion' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileFixedVersion',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'SystemVersionProcessingMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSystemVersionProcessingMode',
      ),
    ),
    ),
    'ExpansionProfile.ExcludedSystem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileExcludedSystem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ExpansionProfile.Designation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'include' =>
      array (
        'setter' => 'setInclude',
        'element' => 'ExpansionProfile.Include',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileInclude',
      ),
      'exclude' =>
      array (
        'setter' => 'setExclude',
        'element' => 'ExpansionProfile.Exclude',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileExclude',
      ),
    ),
    ),
    'ExpansionProfile.Include' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileInclude',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'designation' =>
      array (
        'setter' => 'addDesignation',
        'element' => 'ExpansionProfile.Designation1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation1',
      ),
    ),
    ),
    'ExpansionProfile.Designation1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'ExpansionProfile.Exclude' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileExclude',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'designation' =>
      array (
        'setter' => 'addDesignation',
        'element' => 'ExpansionProfile.Designation2',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation2',
      ),
    ),
    ),
    'ExpansionProfile.Designation2' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExpansionProfile\\FHIRExpansionProfileDesignation2',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'SystemVersionProcessingMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRSystemVersionProcessingMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'SystemVersionProcessingMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'ExplanationOfBenefit' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRExplanationOfBenefit',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ExplanationOfBenefitStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExplanationOfBenefitStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subType' =>
      array (
        'setter' => 'addSubType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'billablePeriod' =>
      array (
        'setter' => 'setBillablePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'insurer' =>
      array (
        'setter' => 'setInsurer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'referral' =>
      array (
        'setter' => 'setReferral',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'facility' =>
      array (
        'setter' => 'setFacility',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'claimResponse' =>
      array (
        'setter' => 'setClaimResponse',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'ExplanationOfBenefit.Related',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitRelated',
      ),
      'prescription' =>
      array (
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'originalPrescription' =>
      array (
        'setter' => 'setOriginalPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'payee' =>
      array (
        'setter' => 'setPayee',
        'element' => 'ExplanationOfBenefit.Payee',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayee',
      ),
      'information' =>
      array (
        'setter' => 'addInformation',
        'element' => 'ExplanationOfBenefit.Information',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInformation',
      ),
      'careTeam' =>
      array (
        'setter' => 'addCareTeam',
        'element' => 'ExplanationOfBenefit.CareTeam',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitCareTeam',
      ),
      'diagnosis' =>
      array (
        'setter' => 'addDiagnosis',
        'element' => 'ExplanationOfBenefit.Diagnosis',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDiagnosis',
      ),
      'procedure' =>
      array (
        'setter' => 'addProcedure',
        'element' => 'ExplanationOfBenefit.Procedure',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcedure',
      ),
      'precedence' =>
      array (
        'setter' => 'setPrecedence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'insurance' =>
      array (
        'setter' => 'setInsurance',
        'element' => 'ExplanationOfBenefit.Insurance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInsurance',
      ),
      'accident' =>
      array (
        'setter' => 'setAccident',
        'element' => 'ExplanationOfBenefit.Accident',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAccident',
      ),
      'employmentImpacted' =>
      array (
        'setter' => 'setEmploymentImpacted',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'hospitalization' =>
      array (
        'setter' => 'setHospitalization',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'ExplanationOfBenefit.Item',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitItem',
      ),
      'addItem' =>
      array (
        'setter' => 'addAddItem',
        'element' => 'ExplanationOfBenefit.AddItem',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAddItem',
      ),
      'totalCost' =>
      array (
        'setter' => 'setTotalCost',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'unallocDeductable' =>
      array (
        'setter' => 'setUnallocDeductable',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'totalBenefit' =>
      array (
        'setter' => 'setTotalBenefit',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'payment' =>
      array (
        'setter' => 'setPayment',
        'element' => 'ExplanationOfBenefit.Payment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayment',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'processNote' =>
      array (
        'setter' => 'addProcessNote',
        'element' => 'ExplanationOfBenefit.ProcessNote',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcessNote',
      ),
      'benefitBalance' =>
      array (
        'setter' => 'addBenefitBalance',
        'element' => 'ExplanationOfBenefit.BenefitBalance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitBenefitBalance',
      ),
    ),
    ),
    'ExplanationOfBenefit.Related' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'claim' =>
      array (
        'setter' => 'setClaim',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reference' =>
      array (
        'setter' => 'setReference',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'ExplanationOfBenefit.Payee' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayee',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'resourceType' =>
      array (
        'setter' => 'setResourceType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'party' =>
      array (
        'setter' => 'setParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ExplanationOfBenefit.Information' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInformation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'timingDate' =>
      array (
        'setter' => 'setTimingDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'timingPeriod' =>
      array (
        'setter' => 'setTimingPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
    ),
    ),
    'ExplanationOfBenefit.CareTeam' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitCareTeam',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'qualification' =>
      array (
        'setter' => 'setQualification',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ExplanationOfBenefit.Diagnosis' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDiagnosis',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisCodeableConcept' =>
      array (
        'setter' => 'setDiagnosisCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnosisReference' =>
      array (
        'setter' => 'setDiagnosisReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'packageCode' =>
      array (
        'setter' => 'setPackageCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ExplanationOfBenefit.Procedure' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcedure',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'procedureCodeableConcept' =>
      array (
        'setter' => 'setProcedureCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'procedureReference' =>
      array (
        'setter' => 'setProcedureReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ExplanationOfBenefit.Insurance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitInsurance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'coverage' =>
      array (
        'setter' => 'setCoverage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'preAuthRef' =>
      array (
        'setter' => 'addPreAuthRef',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ExplanationOfBenefit.Accident' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAccident',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ExplanationOfBenefit.Item' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'careTeamLinkId' =>
      array (
        'setter' => 'addCareTeamLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'diagnosisLinkId' =>
      array (
        'setter' => 'addDiagnosisLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'procedureLinkId' =>
      array (
        'setter' => 'addProcedureLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'informationLinkId' =>
      array (
        'setter' => 'addInformationLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'servicedDate' =>
      array (
        'setter' => 'setServicedDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'servicedPeriod' =>
      array (
        'setter' => 'setServicedPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'locationCodeableConcept' =>
      array (
        'setter' => 'setLocationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'locationAddress' =>
      array (
        'setter' => 'setLocationAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'locationReference' =>
      array (
        'setter' => 'setLocationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subSite' =>
      array (
        'setter' => 'addSubSite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'encounter' =>
      array (
        'setter' => 'addEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ExplanationOfBenefit.Detail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail',
      ),
    ),
    ),
    'ExplanationOfBenefit.Adjudication' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'ExplanationOfBenefit.Detail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'subDetail' =>
      array (
        'setter' => 'addSubDetail',
        'element' => 'ExplanationOfBenefit.SubDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail',
      ),
    ),
    ),
    'ExplanationOfBenefit.SubDetail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitSubDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequence' =>
      array (
        'setter' => 'setSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'programCode' =>
      array (
        'setter' => 'addProgramCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'unitPrice' =>
      array (
        'setter' => 'setUnitPrice',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'factor' =>
      array (
        'setter' => 'setFactor',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'net' =>
      array (
        'setter' => 'setNet',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'udi' =>
      array (
        'setter' => 'addUdi',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
    ),
    ),
    'ExplanationOfBenefit.AddItem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAddItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sequenceLinkId' =>
      array (
        'setter' => 'addSequenceLinkId',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fee' =>
      array (
        'setter' => 'setFee',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'ExplanationOfBenefit.Detail1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail1',
      ),
    ),
    ),
    'ExplanationOfBenefit.Detail1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitDetail1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'revenue' =>
      array (
        'setter' => 'setRevenue',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'service' =>
      array (
        'setter' => 'setService',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'modifier' =>
      array (
        'setter' => 'addModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'fee' =>
      array (
        'setter' => 'setFee',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'noteNumber' =>
      array (
        'setter' => 'addNoteNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'adjudication' =>
      array (
        'setter' => 'addAdjudication',
        'element' => 'ExplanationOfBenefit.Adjudication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitAdjudication',
      ),
    ),
    ),
    'ExplanationOfBenefit.Payment' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitPayment',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'adjustment' =>
      array (
        'setter' => 'setAdjustment',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'adjustmentReason' =>
      array (
        'setter' => 'setAdjustmentReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
    ),
    ),
    'ExplanationOfBenefit.ProcessNote' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitProcessNote',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ExplanationOfBenefit.BenefitBalance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitBenefitBalance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subCategory' =>
      array (
        'setter' => 'setSubCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'excluded' =>
      array (
        'setter' => 'setExcluded',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'network' =>
      array (
        'setter' => 'setNetwork',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'unit' =>
      array (
        'setter' => 'setUnit',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'term' =>
      array (
        'setter' => 'setTerm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'financial' =>
      array (
        'setter' => 'addFinancial',
        'element' => 'ExplanationOfBenefit.Financial',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitFinancial',
      ),
    ),
    ),
    'ExplanationOfBenefit.Financial' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRExplanationOfBenefit\\FHIRExplanationOfBenefitFinancial',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'allowedUnsignedInt' =>
      array (
        'setter' => 'setAllowedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'allowedString' =>
      array (
        'setter' => 'setAllowedString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'allowedMoney' =>
      array (
        'setter' => 'setAllowedMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'usedUnsignedInt' =>
      array (
        'setter' => 'setUsedUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'usedMoney' =>
      array (
        'setter' => 'setUsedMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
    ),
    ),
    'ExplanationOfBenefitStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRExplanationOfBenefitStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ExplanationOfBenefitStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'FamilyMemberHistory' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRFamilyMemberHistory',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FamilyHistoryStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFamilyHistoryStatus',
      ),
      'notDone' =>
      array (
        'setter' => 'setNotDone',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'notDoneReason' =>
      array (
        'setter' => 'setNotDoneReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'relationship' =>
      array (
        'setter' => 'setRelationship',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'gender' =>
      array (
        'setter' => 'setGender',
        'element' => 'AdministrativeGender',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdministrativeGender',
      ),
      'bornPeriod' =>
      array (
        'setter' => 'setBornPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'bornDate' =>
      array (
        'setter' => 'setBornDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'bornString' =>
      array (
        'setter' => 'setBornString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'ageAge' =>
      array (
        'setter' => 'setAgeAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'ageRange' =>
      array (
        'setter' => 'setAgeRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'ageString' =>
      array (
        'setter' => 'setAgeString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'estimatedAge' =>
      array (
        'setter' => 'setEstimatedAge',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'deceasedBoolean' =>
      array (
        'setter' => 'setDeceasedBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'deceasedAge' =>
      array (
        'setter' => 'setDeceasedAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'deceasedRange' =>
      array (
        'setter' => 'setDeceasedRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'deceasedDate' =>
      array (
        'setter' => 'setDeceasedDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'deceasedString' =>
      array (
        'setter' => 'setDeceasedString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'condition' =>
      array (
        'setter' => 'addCondition',
        'element' => 'FamilyMemberHistory.Condition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRFamilyMemberHistory\\FHIRFamilyMemberHistoryCondition',
      ),
    ),
    ),
    'FamilyMemberHistory.Condition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRFamilyMemberHistory\\FHIRFamilyMemberHistoryCondition',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'onsetAge' =>
      array (
        'setter' => 'setOnsetAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'onsetRange' =>
      array (
        'setter' => 'setOnsetRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'onsetPeriod' =>
      array (
        'setter' => 'setOnsetPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'onsetString' =>
      array (
        'setter' => 'setOnsetString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'FamilyHistoryStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRFamilyHistoryStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FamilyHistoryStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Flag' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRFlag',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FlagStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFlagStatus',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'FlagStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRFlagStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FlagStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Goal' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGoal',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'GoalStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGoalStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'startDate' =>
      array (
        'setter' => 'setStartDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'startCodeableConcept' =>
      array (
        'setter' => 'setStartCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Goal.Target',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGoal\\FHIRGoalTarget',
      ),
      'statusDate' =>
      array (
        'setter' => 'setStatusDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'statusReason' =>
      array (
        'setter' => 'setStatusReason',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'expressedBy' =>
      array (
        'setter' => 'setExpressedBy',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'addresses' =>
      array (
        'setter' => 'addAddresses',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'outcomeCode' =>
      array (
        'setter' => 'addOutcomeCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'outcomeReference' =>
      array (
        'setter' => 'addOutcomeReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Goal.Target' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRGoal\\FHIRGoalTarget',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'measure' =>
      array (
        'setter' => 'setMeasure',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'detailQuantity' =>
      array (
        'setter' => 'setDetailQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'detailRange' =>
      array (
        'setter' => 'setDetailRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'detailCodeableConcept' =>
      array (
        'setter' => 'setDetailCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dueDate' =>
      array (
        'setter' => 'setDueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'dueDuration' =>
      array (
        'setter' => 'setDueDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
    ),
    ),
    'GoalStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRGoalStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GoalStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'GraphDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGraphDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'start' =>
      array (
        'setter' => 'setStart',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'GraphDefinition.Link',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink',
      ),
    ),
    ),
    'GraphDefinition.Link' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'sliceName' =>
      array (
        'setter' => 'setSliceName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'addTarget',
        'element' => 'GraphDefinition.Target',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionTarget',
      ),
    ),
    ),
    'GraphDefinition.Target' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionTarget',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'compartment' =>
      array (
        'setter' => 'addCompartment',
        'element' => 'GraphDefinition.Compartment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionCompartment',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'GraphDefinition.Link',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionLink',
      ),
    ),
    ),
    'GraphDefinition.Compartment' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRGraphDefinition\\FHIRGraphDefinitionCompartment',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CompartmentType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCompartmentType',
      ),
      'rule' =>
      array (
        'setter' => 'setRule',
        'element' => 'GraphCompartmentRule',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGraphCompartmentRule',
      ),
      'expression' =>
      array (
        'setter' => 'setExpression',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'GraphCompartmentRule' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRGraphCompartmentRule',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GraphCompartmentRule-list',
        'type' => 'string',
      ),
    ),
    ),
    'Group' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGroup',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'GroupType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGroupType',
      ),
      'actual' =>
      array (
        'setter' => 'setActual',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'characteristic' =>
      array (
        'setter' => 'addCharacteristic',
        'element' => 'Group.Characteristic',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGroup\\FHIRGroupCharacteristic',
      ),
      'member' =>
      array (
        'setter' => 'addMember',
        'element' => 'Group.Member',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRGroup\\FHIRGroupMember',
      ),
    ),
    ),
    'Group.Characteristic' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRGroup\\FHIRGroupCharacteristic',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'exclude' =>
      array (
        'setter' => 'setExclude',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Group.Member' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRGroup\\FHIRGroupMember',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'entity' =>
      array (
        'setter' => 'setEntity',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'inactive' =>
      array (
        'setter' => 'setInactive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'GroupType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRGroupType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GroupType-list',
        'type' => 'string',
      ),
    ),
    ),
    'GuidanceResponse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRGuidanceResponse',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'requestId' =>
      array (
        'setter' => 'setRequestId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'module' =>
      array (
        'setter' => 'setModule',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'GuidanceResponseStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuidanceResponseStatus',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'performer' =>
      array (
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reasonCodeableConcept' =>
      array (
        'setter' => 'setReasonCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'setReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'evaluationMessage' =>
      array (
        'setter' => 'addEvaluationMessage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'outputParameters' =>
      array (
        'setter' => 'setOutputParameters',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'result' =>
      array (
        'setter' => 'setResult',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'dataRequirement' =>
      array (
        'setter' => 'addDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataRequirement',
      ),
    ),
    ),
    'GuidanceResponseStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuidanceResponseStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GuidanceResponseStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'HealthcareService' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRHealthcareService',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'providedBy' =>
      array (
        'setter' => 'setProvidedBy',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specialty' =>
      array (
        'setter' => 'addSpecialty',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'location' =>
      array (
        'setter' => 'addLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'extraDetails' =>
      array (
        'setter' => 'setExtraDetails',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'photo' =>
      array (
        'setter' => 'setPhoto',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'coverageArea' =>
      array (
        'setter' => 'addCoverageArea',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'serviceProvisionCode' =>
      array (
        'setter' => 'addServiceProvisionCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'eligibility' =>
      array (
        'setter' => 'setEligibility',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'eligibilityNote' =>
      array (
        'setter' => 'setEligibilityNote',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'programName' =>
      array (
        'setter' => 'addProgramName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'characteristic' =>
      array (
        'setter' => 'addCharacteristic',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'referralMethod' =>
      array (
        'setter' => 'addReferralMethod',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'appointmentRequired' =>
      array (
        'setter' => 'setAppointmentRequired',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'availableTime' =>
      array (
        'setter' => 'addAvailableTime',
        'element' => 'HealthcareService.AvailableTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceAvailableTime',
      ),
      'notAvailable' =>
      array (
        'setter' => 'addNotAvailable',
        'element' => 'HealthcareService.NotAvailable',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceNotAvailable',
      ),
      'availabilityExceptions' =>
      array (
        'setter' => 'setAvailabilityExceptions',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'HealthcareService.AvailableTime' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceAvailableTime',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'daysOfWeek' =>
      array (
        'setter' => 'addDaysOfWeek',
        'element' => 'DaysOfWeek',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDaysOfWeek',
      ),
      'allDay' =>
      array (
        'setter' => 'setAllDay',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'availableStartTime' =>
      array (
        'setter' => 'setAvailableStartTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'availableEndTime' =>
      array (
        'setter' => 'setAvailableEndTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
    ),
    ),
    'HealthcareService.NotAvailable' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRHealthcareService\\FHIRHealthcareServiceNotAvailable',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'during' =>
      array (
        'setter' => 'setDuring',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'DaysOfWeek' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDaysOfWeek',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DaysOfWeek-list',
        'type' => 'string',
      ),
    ),
    ),
    'ImagingManifest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImagingManifest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'authoringTime' =>
      array (
        'setter' => 'setAuthoringTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'study' =>
      array (
        'setter' => 'addStudy',
        'element' => 'ImagingManifest.Study',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestStudy',
      ),
    ),
    ),
    'ImagingManifest.Study' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestStudy',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'imagingStudy' =>
      array (
        'setter' => 'setImagingStudy',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'series' =>
      array (
        'setter' => 'addSeries',
        'element' => 'ImagingManifest.Series',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestSeries',
      ),
    ),
    ),
    'ImagingManifest.Series' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestSeries',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'instance' =>
      array (
        'setter' => 'addInstance',
        'element' => 'ImagingManifest.Instance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestInstance',
      ),
    ),
    ),
    'ImagingManifest.Instance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingManifest\\FHIRImagingManifestInstance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'sopClass' =>
      array (
        'setter' => 'setSopClass',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
    ),
    ),
    'ImagingStudy' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImagingStudy',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'accession' =>
      array (
        'setter' => 'setAccession',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'availability' =>
      array (
        'setter' => 'setAvailability',
        'element' => 'InstanceAvailability',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstanceAvailability',
      ),
      'modalityList' =>
      array (
        'setter' => 'addModalityList',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'started' =>
      array (
        'setter' => 'setStarted',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'referrer' =>
      array (
        'setter' => 'setReferrer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'interpreter' =>
      array (
        'setter' => 'addInterpreter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'numberOfSeries' =>
      array (
        'setter' => 'setNumberOfSeries',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'numberOfInstances' =>
      array (
        'setter' => 'setNumberOfInstances',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'procedureReference' =>
      array (
        'setter' => 'addProcedureReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'procedureCode' =>
      array (
        'setter' => 'addProcedureCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'series' =>
      array (
        'setter' => 'addSeries',
        'element' => 'ImagingStudy.Series',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudySeries',
      ),
    ),
    ),
    'ImagingStudy.Series' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudySeries',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'modality' =>
      array (
        'setter' => 'setModality',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'numberOfInstances' =>
      array (
        'setter' => 'setNumberOfInstances',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'availability' =>
      array (
        'setter' => 'setAvailability',
        'element' => 'InstanceAvailability',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstanceAvailability',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'laterality' =>
      array (
        'setter' => 'setLaterality',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'started' =>
      array (
        'setter' => 'setStarted',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'instance' =>
      array (
        'setter' => 'addInstance',
        'element' => 'ImagingStudy.Instance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyInstance',
      ),
    ),
    ),
    'ImagingStudy.Instance' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImagingStudy\\FHIRImagingStudyInstance',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'uid' =>
      array (
        'setter' => 'setUid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'number' =>
      array (
        'setter' => 'setNumber',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'sopClass' =>
      array (
        'setter' => 'setSopClass',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'InstanceAvailability' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstanceAvailability',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'InstanceAvailability-list',
        'type' => 'string',
      ),
    ),
    ),
    'Immunization' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImmunization',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ImmunizationStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRImmunizationStatusCodes',
      ),
      'notGiven' =>
      array (
        'setter' => 'setNotGiven',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'vaccineCode' =>
      array (
        'setter' => 'setVaccineCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'primarySource' =>
      array (
        'setter' => 'setPrimarySource',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'reportOrigin' =>
      array (
        'setter' => 'setReportOrigin',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'location' =>
      array (
        'setter' => 'setLocation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'manufacturer' =>
      array (
        'setter' => 'setManufacturer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'lotNumber' =>
      array (
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'expirationDate' =>
      array (
        'setter' => 'setExpirationDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'route' =>
      array (
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseQuantity' =>
      array (
        'setter' => 'setDoseQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'practitioner' =>
      array (
        'setter' => 'addPractitioner',
        'element' => 'Immunization.Practitioner',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationPractitioner',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'explanation' =>
      array (
        'setter' => 'setExplanation',
        'element' => 'Immunization.Explanation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationExplanation',
      ),
      'reaction' =>
      array (
        'setter' => 'addReaction',
        'element' => 'Immunization.Reaction',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationReaction',
      ),
      'vaccinationProtocol' =>
      array (
        'setter' => 'addVaccinationProtocol',
        'element' => 'Immunization.VaccinationProtocol',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationVaccinationProtocol',
      ),
    ),
    ),
    'Immunization.Practitioner' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationPractitioner',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'role' =>
      array (
        'setter' => 'setRole',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Immunization.Explanation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationExplanation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonNotGiven' =>
      array (
        'setter' => 'addReasonNotGiven',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Immunization.Reaction' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationReaction',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'detail' =>
      array (
        'setter' => 'setDetail',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reported' =>
      array (
        'setter' => 'setReported',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'Immunization.VaccinationProtocol' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunization\\FHIRImmunizationVaccinationProtocol',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'doseSequence' =>
      array (
        'setter' => 'setDoseSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'series' =>
      array (
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'seriesDoses' =>
      array (
        'setter' => 'setSeriesDoses',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'targetDisease' =>
      array (
        'setter' => 'addTargetDisease',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseStatus' =>
      array (
        'setter' => 'setDoseStatus',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseStatusReason' =>
      array (
        'setter' => 'setDoseStatusReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'ImmunizationStatusCodes' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRImmunizationStatusCodes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ImmunizationStatusCodes-list',
        'type' => 'string',
      ),
    ),
    ),
    'ImmunizationRecommendation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImmunizationRecommendation',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'recommendation' =>
      array (
        'setter' => 'addRecommendation',
        'element' => 'ImmunizationRecommendation.Recommendation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationRecommendation',
      ),
    ),
    ),
    'ImmunizationRecommendation.Recommendation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationRecommendation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'vaccineCode' =>
      array (
        'setter' => 'setVaccineCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'targetDisease' =>
      array (
        'setter' => 'setTargetDisease',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'doseNumber' =>
      array (
        'setter' => 'setDoseNumber',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'forecastStatus' =>
      array (
        'setter' => 'setForecastStatus',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dateCriterion' =>
      array (
        'setter' => 'addDateCriterion',
        'element' => 'ImmunizationRecommendation.DateCriterion',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationDateCriterion',
      ),
      'protocol' =>
      array (
        'setter' => 'setProtocol',
        'element' => 'ImmunizationRecommendation.Protocol',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationProtocol',
      ),
      'supportingImmunization' =>
      array (
        'setter' => 'addSupportingImmunization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'supportingPatientInformation' =>
      array (
        'setter' => 'addSupportingPatientInformation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ImmunizationRecommendation.DateCriterion' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationDateCriterion',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'ImmunizationRecommendation.Protocol' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImmunizationRecommendation\\FHIRImmunizationRecommendationProtocol',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'doseSequence' =>
      array (
        'setter' => 'setDoseSequence',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'authority' =>
      array (
        'setter' => 'setAuthority',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'series' =>
      array (
        'setter' => 'setSeries',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'ImplementationGuide' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRImplementationGuide',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'fhirVersion' =>
      array (
        'setter' => 'setFhirVersion',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'dependency' =>
      array (
        'setter' => 'addDependency',
        'element' => 'ImplementationGuide.Dependency',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDependency',
      ),
      'package' =>
      array (
        'setter' => 'addPackage',
        'element' => 'ImplementationGuide.Package',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePackage',
      ),
      'global' =>
      array (
        'setter' => 'addGlobal',
        'element' => 'ImplementationGuide.Global',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGlobal',
      ),
      'binary' =>
      array (
        'setter' => 'addBinary',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'page' =>
      array (
        'setter' => 'setPage',
        'element' => 'ImplementationGuide.Page',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage',
      ),
    ),
    ),
    'ImplementationGuide.Dependency' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideDependency',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'GuideDependencyType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuideDependencyType',
      ),
      'uri' =>
      array (
        'setter' => 'setUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'ImplementationGuide.Package' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePackage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'ImplementationGuide.Resource',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource',
      ),
    ),
    ),
    'ImplementationGuide.Resource' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideResource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'example' =>
      array (
        'setter' => 'setExample',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'acronym' =>
      array (
        'setter' => 'setAcronym',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'sourceUri' =>
      array (
        'setter' => 'setSourceUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'sourceReference' =>
      array (
        'setter' => 'setSourceReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'exampleFor' =>
      array (
        'setter' => 'setExampleFor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ImplementationGuide.Global' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuideGlobal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ImplementationGuide.Page' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'GuidePageKind',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuidePageKind',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'package' =>
      array (
        'setter' => 'addPackage',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'format' =>
      array (
        'setter' => 'setFormat',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'page' =>
      array (
        'setter' => 'addPage',
        'element' => 'ImplementationGuide.Page',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRImplementationGuide\\FHIRImplementationGuidePage',
      ),
    ),
    ),
    'GuideDependencyType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuideDependencyType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GuideDependencyType-list',
        'type' => 'string',
      ),
    ),
    ),
    'GuidePageKind' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRGuidePageKind',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'GuidePageKind-list',
        'type' => 'string',
      ),
    ),
    ),
    'Library' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLibrary',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'usage' =>
      array (
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contributor' =>
      array (
        'setter' => 'addContributor',
        'element' => 'Contributor',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributor',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'parameter' =>
      array (
        'setter' => 'addParameter',
        'element' => 'ParameterDefinition',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRParameterDefinition',
      ),
      'dataRequirement' =>
      array (
        'setter' => 'addDataRequirement',
        'element' => 'DataRequirement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDataRequirement',
      ),
      'content' =>
      array (
        'setter' => 'addContent',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
    ),
    ),
    'Linkage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLinkage',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'item' =>
      array (
        'setter' => 'addItem',
        'element' => 'Linkage.Item',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRLinkage\\FHIRLinkageItem',
      ),
    ),
    ),
    'Linkage.Item' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRLinkage\\FHIRLinkageItem',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'LinkageType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLinkageType',
      ),
      'resource' =>
      array (
        'setter' => 'setResource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'LinkageType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRLinkageType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'LinkageType-list',
        'type' => 'string',
      ),
    ),
    ),
    'List' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRList',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ListStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRListStatus',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'ListMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRListMode',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'orderedBy' =>
      array (
        'setter' => 'setOrderedBy',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'entry' =>
      array (
        'setter' => 'addEntry',
        'element' => 'List.Entry',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRList\\FHIRListEntry',
      ),
      'emptyReason' =>
      array (
        'setter' => 'setEmptyReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'List.Entry' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRList\\FHIRListEntry',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'flag' =>
      array (
        'setter' => 'setFlag',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'deleted' =>
      array (
        'setter' => 'setDeleted',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'item' =>
      array (
        'setter' => 'setItem',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ListStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRListStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ListStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Location' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRLocation',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'LocationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLocationStatus',
      ),
      'operationalStatus' =>
      array (
        'setter' => 'setOperationalStatus',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'alias' =>
      array (
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'mode' =>
      array (
        'setter' => 'setMode',
        'element' => 'LocationMode',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLocationMode',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'physicalType' =>
      array (
        'setter' => 'setPhysicalType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'position' =>
      array (
        'setter' => 'setPosition',
        'element' => 'Location.Position',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRLocation\\FHIRLocationPosition',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Location.Position' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRLocation\\FHIRLocationPosition',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'longitude' =>
      array (
        'setter' => 'setLongitude',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'latitude' =>
      array (
        'setter' => 'setLatitude',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'altitude' =>
      array (
        'setter' => 'setAltitude',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'LocationMode' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRLocationMode',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'LocationMode-list',
        'type' => 'string',
      ),
    ),
    ),
    'LocationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRLocationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'LocationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Measure' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMeasure',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'usage' =>
      array (
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'approvalDate' =>
      array (
        'setter' => 'setApprovalDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'lastReviewDate' =>
      array (
        'setter' => 'setLastReviewDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'topic' =>
      array (
        'setter' => 'addTopic',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'contributor' =>
      array (
        'setter' => 'addContributor',
        'element' => 'Contributor',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContributor',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'relatedArtifact' =>
      array (
        'setter' => 'addRelatedArtifact',
        'element' => 'RelatedArtifact',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRelatedArtifact',
      ),
      'library' =>
      array (
        'setter' => 'addLibrary',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'disclaimer' =>
      array (
        'setter' => 'setDisclaimer',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'scoring' =>
      array (
        'setter' => 'setScoring',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'compositeScoring' =>
      array (
        'setter' => 'setCompositeScoring',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'riskAdjustment' =>
      array (
        'setter' => 'setRiskAdjustment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'rateAggregation' =>
      array (
        'setter' => 'setRateAggregation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'rationale' =>
      array (
        'setter' => 'setRationale',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'clinicalRecommendationStatement' =>
      array (
        'setter' => 'setClinicalRecommendationStatement',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'improvementNotation' =>
      array (
        'setter' => 'setImprovementNotation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'guidance' =>
      array (
        'setter' => 'setGuidance',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'set' =>
      array (
        'setter' => 'setSet',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'group' =>
      array (
        'setter' => 'addGroup',
        'element' => 'Measure.Group',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureGroup',
      ),
      'supplementalData' =>
      array (
        'setter' => 'addSupplementalData',
        'element' => 'Measure.SupplementalData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureSupplementalData',
      ),
    ),
    ),
    'Measure.Group' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureGroup',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'population' =>
      array (
        'setter' => 'addPopulation',
        'element' => 'Measure.Population',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasurePopulation',
      ),
      'stratifier' =>
      array (
        'setter' => 'addStratifier',
        'element' => 'Measure.Stratifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureStratifier',
      ),
    ),
    ),
    'Measure.Population' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasurePopulation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'criteria' =>
      array (
        'setter' => 'setCriteria',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Measure.Stratifier' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureStratifier',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'criteria' =>
      array (
        'setter' => 'setCriteria',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Measure.SupplementalData' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasure\\FHIRMeasureSupplementalData',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'usage' =>
      array (
        'setter' => 'addUsage',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'criteria' =>
      array (
        'setter' => 'setCriteria',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'path' =>
      array (
        'setter' => 'setPath',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'MeasureReport' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMeasureReport',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'MeasureReportStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasureReportStatus',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'MeasureReportType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasureReportType',
      ),
      'measure' =>
      array (
        'setter' => 'setMeasure',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'reportingOrganization' =>
      array (
        'setter' => 'setReportingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'group' =>
      array (
        'setter' => 'addGroup',
        'element' => 'MeasureReport.Group',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportGroup',
      ),
      'evaluatedResources' =>
      array (
        'setter' => 'setEvaluatedResources',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MeasureReport.Group' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportGroup',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'population' =>
      array (
        'setter' => 'addPopulation',
        'element' => 'MeasureReport.Population',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation',
      ),
      'measureScore' =>
      array (
        'setter' => 'setMeasureScore',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'stratifier' =>
      array (
        'setter' => 'addStratifier',
        'element' => 'MeasureReport.Stratifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratifier',
      ),
    ),
    ),
    'MeasureReport.Population' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'count' =>
      array (
        'setter' => 'setCount',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'patients' =>
      array (
        'setter' => 'setPatients',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MeasureReport.Stratifier' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratifier',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'stratum' =>
      array (
        'setter' => 'addStratum',
        'element' => 'MeasureReport.Stratum',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratum',
      ),
    ),
    ),
    'MeasureReport.Stratum' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportStratum',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'population' =>
      array (
        'setter' => 'addPopulation',
        'element' => 'MeasureReport.Population1',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation1',
      ),
      'measureScore' =>
      array (
        'setter' => 'setMeasureScore',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
    ),
    ),
    'MeasureReport.Population1' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMeasureReport\\FHIRMeasureReportPopulation1',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'count' =>
      array (
        'setter' => 'setCount',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'patients' =>
      array (
        'setter' => 'setPatients',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MeasureReportStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasureReportStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MeasureReportStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'MeasureReportType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeasureReportType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MeasureReportType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Media' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedia',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'DigitalMediaType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDigitalMediaType',
      ),
      'subtype' =>
      array (
        'setter' => 'setSubtype',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'view' =>
      array (
        'setter' => 'setView',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'occurrenceDateTime' =>
      array (
        'setter' => 'setOccurrenceDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'occurrencePeriod' =>
      array (
        'setter' => 'setOccurrencePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'operator' =>
      array (
        'setter' => 'setOperator',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'device' =>
      array (
        'setter' => 'setDevice',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'height' =>
      array (
        'setter' => 'setHeight',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'width' =>
      array (
        'setter' => 'setWidth',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'frames' =>
      array (
        'setter' => 'setFrames',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'duration' =>
      array (
        'setter' => 'setDuration',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'content' =>
      array (
        'setter' => 'setContent',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
    ),
    ),
    'DigitalMediaType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRDigitalMediaType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'DigitalMediaType-list',
        'type' => 'string',
      ),
    ),
    ),
    'Medication' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedication',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'MedicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatus',
      ),
      'isBrand' =>
      array (
        'setter' => 'setIsBrand',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'isOverTheCounter' =>
      array (
        'setter' => 'setIsOverTheCounter',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'manufacturer' =>
      array (
        'setter' => 'setManufacturer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'ingredient' =>
      array (
        'setter' => 'addIngredient',
        'element' => 'Medication.Ingredient',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationIngredient',
      ),
      'package' =>
      array (
        'setter' => 'setPackage',
        'element' => 'Medication.Package',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationPackage',
      ),
      'image' =>
      array (
        'setter' => 'addImage',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
    ),
    ),
    'Medication.Ingredient' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationIngredient',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'itemCodeableConcept' =>
      array (
        'setter' => 'setItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'itemReference' =>
      array (
        'setter' => 'setItemReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'isActive' =>
      array (
        'setter' => 'setIsActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
    ),
    ),
    'Medication.Package' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationPackage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'container' =>
      array (
        'setter' => 'setContainer',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'content' =>
      array (
        'setter' => 'addContent',
        'element' => 'Medication.Content',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationContent',
      ),
      'batch' =>
      array (
        'setter' => 'addBatch',
        'element' => 'Medication.Batch',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationBatch',
      ),
    ),
    ),
    'Medication.Content' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationContent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'itemCodeableConcept' =>
      array (
        'setter' => 'setItemCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'itemReference' =>
      array (
        'setter' => 'setItemReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'Medication.Batch' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedication\\FHIRMedicationBatch',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'lotNumber' =>
      array (
        'setter' => 'setLotNumber',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'expirationDate' =>
      array (
        'setter' => 'setExpirationDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
    ),
    ),
    'MedicationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationAdministration' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationAdministration',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'MedicationAdministrationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationAdministrationStatus',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationCodeableConcept' =>
      array (
        'setter' => 'setMedicationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationReference' =>
      array (
        'setter' => 'setMedicationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'MedicationAdministration.Performer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationPerformer',
      ),
      'notGiven' =>
      array (
        'setter' => 'setNotGiven',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'reasonNotGiven' =>
      array (
        'setter' => 'addReasonNotGiven',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'prescription' =>
      array (
        'setter' => 'setPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'device' =>
      array (
        'setter' => 'addDevice',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'dosage' =>
      array (
        'setter' => 'setDosage',
        'element' => 'MedicationAdministration.Dosage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationDosage',
      ),
      'eventHistory' =>
      array (
        'setter' => 'addEventHistory',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationAdministration.Performer' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationPerformer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationAdministration.Dosage' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationAdministration\\FHIRMedicationAdministrationDosage',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'site' =>
      array (
        'setter' => 'setSite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'route' =>
      array (
        'setter' => 'setRoute',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'dose' =>
      array (
        'setter' => 'setDose',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'rateRatio' =>
      array (
        'setter' => 'setRateRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'rateQuantity' =>
      array (
        'setter' => 'setRateQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'MedicationAdministrationStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationAdministrationStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationAdministrationStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationDispense' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationDispense',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'MedicationDispenseStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationDispenseStatus',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationCodeableConcept' =>
      array (
        'setter' => 'setMedicationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationReference' =>
      array (
        'setter' => 'setMedicationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'MedicationDispense.Performer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispensePerformer',
      ),
      'authorizingPrescription' =>
      array (
        'setter' => 'addAuthorizingPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'daysSupply' =>
      array (
        'setter' => 'setDaysSupply',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'whenPrepared' =>
      array (
        'setter' => 'setWhenPrepared',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'whenHandedOver' =>
      array (
        'setter' => 'setWhenHandedOver',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'destination' =>
      array (
        'setter' => 'setDestination',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'receiver' =>
      array (
        'setter' => 'addReceiver',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'dosageInstruction' =>
      array (
        'setter' => 'addDosageInstruction',
        'element' => 'Dosage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDosage',
      ),
      'substitution' =>
      array (
        'setter' => 'setSubstitution',
        'element' => 'MedicationDispense.Substitution',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispenseSubstitution',
      ),
      'detectedIssue' =>
      array (
        'setter' => 'addDetectedIssue',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'notDone' =>
      array (
        'setter' => 'setNotDone',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'notDoneReasonCodeableConcept' =>
      array (
        'setter' => 'setNotDoneReasonCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'notDoneReasonReference' =>
      array (
        'setter' => 'setNotDoneReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'eventHistory' =>
      array (
        'setter' => 'addEventHistory',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationDispense.Performer' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispensePerformer',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'actor' =>
      array (
        'setter' => 'setActor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationDispense.Substitution' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationDispense\\FHIRMedicationDispenseSubstitution',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'wasSubstituted' =>
      array (
        'setter' => 'setWasSubstituted',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reason' =>
      array (
        'setter' => 'addReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'responsibleParty' =>
      array (
        'setter' => 'addResponsibleParty',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationDispenseStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationDispenseStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationDispenseStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationRequest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationRequest',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'definition' =>
      array (
        'setter' => 'addDefinition',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'groupIdentifier' =>
      array (
        'setter' => 'setGroupIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'MedicationRequestStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestStatus',
      ),
      'intent' =>
      array (
        'setter' => 'setIntent',
        'element' => 'MedicationRequestIntent',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestIntent',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'priority' =>
      array (
        'setter' => 'setPriority',
        'element' => 'MedicationRequestPriority',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestPriority',
      ),
      'medicationCodeableConcept' =>
      array (
        'setter' => 'setMedicationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationReference' =>
      array (
        'setter' => 'setMedicationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'supportingInformation' =>
      array (
        'setter' => 'addSupportingInformation',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'authoredOn' =>
      array (
        'setter' => 'setAuthoredOn',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'requester' =>
      array (
        'setter' => 'setRequester',
        'element' => 'MedicationRequest.Requester',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestRequester',
      ),
      'recorder' =>
      array (
        'setter' => 'setRecorder',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'dosageInstruction' =>
      array (
        'setter' => 'addDosageInstruction',
        'element' => 'Dosage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDosage',
      ),
      'dispenseRequest' =>
      array (
        'setter' => 'setDispenseRequest',
        'element' => 'MedicationRequest.DispenseRequest',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestDispenseRequest',
      ),
      'substitution' =>
      array (
        'setter' => 'setSubstitution',
        'element' => 'MedicationRequest.Substitution',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestSubstitution',
      ),
      'priorPrescription' =>
      array (
        'setter' => 'setPriorPrescription',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'detectedIssue' =>
      array (
        'setter' => 'addDetectedIssue',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'eventHistory' =>
      array (
        'setter' => 'addEventHistory',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationRequest.Requester' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestRequester',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'agent' =>
      array (
        'setter' => 'setAgent',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'onBehalfOf' =>
      array (
        'setter' => 'setOnBehalfOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationRequest.DispenseRequest' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestDispenseRequest',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'validityPeriod' =>
      array (
        'setter' => 'setValidityPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'numberOfRepeatsAllowed' =>
      array (
        'setter' => 'setNumberOfRepeatsAllowed',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'expectedSupplyDuration' =>
      array (
        'setter' => 'setExpectedSupplyDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'performer' =>
      array (
        'setter' => 'setPerformer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MedicationRequest.Substitution' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMedicationRequest\\FHIRMedicationRequestSubstitution',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'allowed' =>
      array (
        'setter' => 'setAllowed',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'MedicationRequestStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationRequestStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationRequestPriority' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestPriority',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationRequestPriority-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationRequestIntent' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationRequestIntent',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationRequestIntent-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationStatement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMedicationStatement',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'partOf' =>
      array (
        'setter' => 'addPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'MedicationStatementStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatementStatus',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationCodeableConcept' =>
      array (
        'setter' => 'setMedicationCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'medicationReference' =>
      array (
        'setter' => 'setMedicationReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'dateAsserted' =>
      array (
        'setter' => 'setDateAsserted',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'informationSource' =>
      array (
        'setter' => 'setInformationSource',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'derivedFrom' =>
      array (
        'setter' => 'addDerivedFrom',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'taken' =>
      array (
        'setter' => 'setTaken',
        'element' => 'MedicationStatementTaken',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatementTaken',
      ),
      'reasonNotTaken' =>
      array (
        'setter' => 'addReasonNotTaken',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonCode' =>
      array (
        'setter' => 'addReasonCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'reasonReference' =>
      array (
        'setter' => 'addReasonReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'note' =>
      array (
        'setter' => 'addNote',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'dosage' =>
      array (
        'setter' => 'addDosage',
        'element' => 'Dosage',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDosage',
      ),
    ),
    ),
    'MedicationStatementStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatementStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationStatementStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'MedicationStatementTaken' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRMedicationStatementTaken',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'MedicationStatementTaken-list',
        'type' => 'string',
      ),
    ),
    ),
    'MessageDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMessageDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'copyright' =>
      array (
        'setter' => 'setCopyright',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'base' =>
      array (
        'setter' => 'setBase',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'parent' =>
      array (
        'setter' => 'addParent',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'replaces' =>
      array (
        'setter' => 'addReplaces',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'event' =>
      array (
        'setter' => 'setEvent',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'category' =>
      array (
        'setter' => 'setCategory',
        'element' => 'MessageSignificanceCategory',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMessageSignificanceCategory',
      ),
      'focus' =>
      array (
        'setter' => 'addFocus',
        'element' => 'MessageDefinition.Focus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionFocus',
      ),
      'responseRequired' =>
      array (
        'setter' => 'setResponseRequired',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'allowedResponse' =>
      array (
        'setter' => 'addAllowedResponse',
        'element' => 'MessageDefinition.AllowedResponse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionAllowedResponse',
      ),
    ),
    ),
    'MessageDefinition.Focus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionFocus',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'MessageDefinition.AllowedResponse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageDefinition\\FHIRMessageDefinitionAllowedResponse',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'message' =>
      array (
        'setter' => 'setMessage',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'situation' =>
      array (
        'setter' => 'setSituation',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
    ),
    ),
    'MessageHeader' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRMessageHeader',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'event' =>
      array (
        'setter' => 'setEvent',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'destination' =>
      array (
        'setter' => 'addDestination',
        'element' => 'MessageHeader.Destination',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderDestination',
      ),
      'receiver' =>
      array (
        'setter' => 'setReceiver',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'sender' =>
      array (
        'setter' => 'setSender',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'timestamp' =>
      array (
        'setter' => 'setTimestamp',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'enterer' =>
      array (
        'setter' => 'setEnterer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'author' =>
      array (
        'setter' => 'setAuthor',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'source' =>
      array (
        'setter' => 'setSource',
        'element' => 'MessageHeader.Source',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderSource',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'reason' =>
      array (
        'setter' => 'setReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'MessageHeader.Response',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderResponse',
      ),
      'focus' =>
      array (
        'setter' => 'addFocus',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'MessageHeader.Destination' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderDestination',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'endpoint' =>
      array (
        'setter' => 'setEndpoint',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'MessageHeader.Source' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderSource',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'software' =>
      array (
        'setter' => 'setSoftware',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'setContact',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'endpoint' =>
      array (
        'setter' => 'setEndpoint',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
    ),
    ),
    'MessageHeader.Response' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRMessageHeader\\FHIRMessageHeaderResponse',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'setIdentifier',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'ResponseType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResponseType',
      ),
      'details' =>
      array (
        'setter' => 'setDetails',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'ResponseType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRResponseType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ResponseType-list',
        'type' => 'string',
      ),
    ),
    ),
    'NamingSystem' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRNamingSystem',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'NamingSystemType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNamingSystemType',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'responsible' =>
      array (
        'setter' => 'setResponsible',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'usage' =>
      array (
        'setter' => 'setUsage',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'uniqueId' =>
      array (
        'setter' => 'addUniqueId',
        'element' => 'NamingSystem.UniqueId',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNamingSystem\\FHIRNamingSystemUniqueId',
      ),
      'replacedBy' =>
      array (
        'setter' => 'setReplacedBy',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'NamingSystem.UniqueId' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNamingSystem\\FHIRNamingSystemUniqueId',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'NamingSystemIdentifierType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNamingSystemIdentifierType',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'preferred' =>
      array (
        'setter' => 'setPreferred',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'NamingSystemIdentifierType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNamingSystemIdentifierType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NamingSystemIdentifierType-list',
        'type' => 'string',
      ),
    ),
    ),
    'NamingSystemType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNamingSystemType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NamingSystemType-list',
        'type' => 'string',
      ),
    ),
    ),
    'NutritionOrder' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRNutritionOrder',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'NutritionOrderStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNutritionOrderStatus',
      ),
      'patient' =>
      array (
        'setter' => 'setPatient',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'encounter' =>
      array (
        'setter' => 'setEncounter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'dateTime' =>
      array (
        'setter' => 'setDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'orderer' =>
      array (
        'setter' => 'setOrderer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'allergyIntolerance' =>
      array (
        'setter' => 'addAllergyIntolerance',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'foodPreferenceModifier' =>
      array (
        'setter' => 'addFoodPreferenceModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'excludeFoodModifier' =>
      array (
        'setter' => 'addExcludeFoodModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'oralDiet' =>
      array (
        'setter' => 'setOralDiet',
        'element' => 'NutritionOrder.OralDiet',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderOralDiet',
      ),
      'supplement' =>
      array (
        'setter' => 'addSupplement',
        'element' => 'NutritionOrder.Supplement',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderSupplement',
      ),
      'enteralFormula' =>
      array (
        'setter' => 'setEnteralFormula',
        'element' => 'NutritionOrder.EnteralFormula',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderEnteralFormula',
      ),
    ),
    ),
    'NutritionOrder.OralDiet' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderOralDiet',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'schedule' =>
      array (
        'setter' => 'addSchedule',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'nutrient' =>
      array (
        'setter' => 'addNutrient',
        'element' => 'NutritionOrder.Nutrient',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderNutrient',
      ),
      'texture' =>
      array (
        'setter' => 'addTexture',
        'element' => 'NutritionOrder.Texture',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderTexture',
      ),
      'fluidConsistencyType' =>
      array (
        'setter' => 'addFluidConsistencyType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'instruction' =>
      array (
        'setter' => 'setInstruction',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'NutritionOrder.Nutrient' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderNutrient',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifier' =>
      array (
        'setter' => 'setModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
    ),
    ),
    'NutritionOrder.Texture' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderTexture',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifier' =>
      array (
        'setter' => 'setModifier',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'foodType' =>
      array (
        'setter' => 'setFoodType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'NutritionOrder.Supplement' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderSupplement',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'productName' =>
      array (
        'setter' => 'setProductName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'schedule' =>
      array (
        'setter' => 'addSchedule',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'instruction' =>
      array (
        'setter' => 'setInstruction',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'NutritionOrder.EnteralFormula' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderEnteralFormula',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'baseFormulaType' =>
      array (
        'setter' => 'setBaseFormulaType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'baseFormulaProductName' =>
      array (
        'setter' => 'setBaseFormulaProductName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'additiveType' =>
      array (
        'setter' => 'setAdditiveType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'additiveProductName' =>
      array (
        'setter' => 'setAdditiveProductName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'caloricDensity' =>
      array (
        'setter' => 'setCaloricDensity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'routeofAdministration' =>
      array (
        'setter' => 'setRouteofAdministration',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'administration' =>
      array (
        'setter' => 'addAdministration',
        'element' => 'NutritionOrder.Administration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderAdministration',
      ),
      'maxVolumeToDeliver' =>
      array (
        'setter' => 'setMaxVolumeToDeliver',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'administrationInstruction' =>
      array (
        'setter' => 'setAdministrationInstruction',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'NutritionOrder.Administration' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRNutritionOrder\\FHIRNutritionOrderAdministration',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'schedule' =>
      array (
        'setter' => 'setSchedule',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'quantity' =>
      array (
        'setter' => 'setQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'rateQuantity' =>
      array (
        'setter' => 'setRateQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'rateRatio' =>
      array (
        'setter' => 'setRateRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
    ),
    ),
    'NutritionOrderStatus' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRNutritionOrderStatus',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'NutritionOrderStatus-list',
        'type' => 'string',
      ),
    ),
    ),
    'Observation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRObservation',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'basedOn' =>
      array (
        'setter' => 'addBasedOn',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'ObservationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationStatus',
      ),
      'category' =>
      array (
        'setter' => 'addCategory',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'subject' =>
      array (
        'setter' => 'setSubject',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'context' =>
      array (
        'setter' => 'setContext',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'effectiveDateTime' =>
      array (
        'setter' => 'setEffectiveDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'effectivePeriod' =>
      array (
        'setter' => 'setEffectivePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'issued' =>
      array (
        'setter' => 'setIssued',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'performer' =>
      array (
        'setter' => 'addPerformer',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'dataAbsentReason' =>
      array (
        'setter' => 'setDataAbsentReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'interpretation' =>
      array (
        'setter' => 'setInterpretation',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'bodySite' =>
      array (
        'setter' => 'setBodySite',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'method' =>
      array (
        'setter' => 'setMethod',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'specimen' =>
      array (
        'setter' => 'setSpecimen',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'device' =>
      array (
        'setter' => 'setDevice',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'referenceRange' =>
      array (
        'setter' => 'addReferenceRange',
        'element' => 'Observation.ReferenceRange',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationReferenceRange',
      ),
      'related' =>
      array (
        'setter' => 'addRelated',
        'element' => 'Observation.Related',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationRelated',
      ),
      'component' =>
      array (
        'setter' => 'addComponent',
        'element' => 'Observation.Component',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationComponent',
      ),
    ),
    ),
    'Observation.ReferenceRange' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationReferenceRange',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'low' =>
      array (
        'setter' => 'setLow',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'high' =>
      array (
        'setter' => 'setHigh',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'appliesTo' =>
      array (
        'setter' => 'addAppliesTo',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'age' =>
      array (
        'setter' => 'setAge',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Observation.Related' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationRelated',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'ObservationRelationshipType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationRelationshipType',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Observation.Component' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationComponent',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'dataAbsentReason' =>
      array (
        'setter' => 'setDataAbsentReason',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'interpretation' =>
      array (
        'setter' => 'setInterpretation',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'referenceRange' =>
      array (
        'setter' => 'addReferenceRange',
        'element' => 'Observation.ReferenceRange',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRObservation\\FHIRObservationReferenceRange',
      ),
    ),
    ),
    'ObservationRelationshipType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRObservationRelationshipType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'ObservationRelationshipType-list',
        'type' => 'string',
      ),
    ),
    ),
    'OperationDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROperationDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'kind' =>
      array (
        'setter' => 'setKind',
        'element' => 'OperationKind',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROperationKind',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'ContactDetail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactDetail',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'useContext' =>
      array (
        'setter' => 'addUseContext',
        'element' => 'UsageContext',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUsageContext',
      ),
      'jurisdiction' =>
      array (
        'setter' => 'addJurisdiction',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'idempotent' =>
      array (
        'setter' => 'setIdempotent',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'base' =>
      array (
        'setter' => 'setBase',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'resource' =>
      array (
        'setter' => 'addResource',
        'element' => 'ResourceType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRResourceType',
      ),
      'system' =>
      array (
        'setter' => 'setSystem',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'instance' =>
      array (
        'setter' => 'setInstance',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'parameter' =>
      array (
        'setter' => 'addParameter',
        'element' => 'OperationDefinition.Parameter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionParameter',
      ),
      'overload' =>
      array (
        'setter' => 'addOverload',
        'element' => 'OperationDefinition.Overload',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionOverload',
      ),
    ),
    ),
    'OperationDefinition.Parameter' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionParameter',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'use' =>
      array (
        'setter' => 'setUse',
        'element' => 'OperationParameterUse',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROperationParameterUse',
      ),
      'min' =>
      array (
        'setter' => 'setMin',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'max' =>
      array (
        'setter' => 'setMax',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'documentation' =>
      array (
        'setter' => 'setDocumentation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'FHIRAllTypes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRAllTypes',
      ),
      'searchType' =>
      array (
        'setter' => 'setSearchType',
        'element' => 'SearchParamType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSearchParamType',
      ),
      'profile' =>
      array (
        'setter' => 'setProfile',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'binding' =>
      array (
        'setter' => 'setBinding',
        'element' => 'OperationDefinition.Binding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionBinding',
      ),
      'part' =>
      array (
        'setter' => 'addPart',
        'element' => 'OperationDefinition.Parameter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionParameter',
      ),
    ),
    ),
    'OperationDefinition.Binding' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionBinding',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'strength' =>
      array (
        'setter' => 'setStrength',
        'element' => 'BindingStrength',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBindingStrength',
      ),
      'valueSetUri' =>
      array (
        'setter' => 'setValueSetUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'valueSetReference' =>
      array (
        'setter' => 'setValueSetReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'OperationDefinition.Overload' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationDefinition\\FHIROperationDefinitionOverload',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'parameterName' =>
      array (
        'setter' => 'addParameterName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'comment' =>
      array (
        'setter' => 'setComment',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'FHIRAllTypes' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRFHIRAllTypes',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'FHIRAllTypes-list',
        'type' => 'string',
      ),
    ),
    ),
    'OperationParameterUse' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIROperationParameterUse',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'OperationParameterUse-list',
        'type' => 'string',
      ),
    ),
    ),
    'OperationKind' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIROperationKind',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'OperationKind-list',
        'type' => 'string',
      ),
    ),
    ),
    'OperationOutcome' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROperationOutcome',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'issue' =>
      array (
        'setter' => 'addIssue',
        'element' => 'OperationOutcome.Issue',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationOutcome\\FHIROperationOutcomeIssue',
      ),
    ),
    ),
    'OperationOutcome.Issue' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIROperationOutcome\\FHIROperationOutcomeIssue',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'severity' =>
      array (
        'setter' => 'setSeverity',
        'element' => 'IssueSeverity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIssueSeverity',
      ),
      'code' =>
      array (
        'setter' => 'setCode',
        'element' => 'IssueType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIssueType',
      ),
      'details' =>
      array (
        'setter' => 'setDetails',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'diagnostics' =>
      array (
        'setter' => 'setDiagnostics',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'location' =>
      array (
        'setter' => 'addLocation',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'expression' =>
      array (
        'setter' => 'addExpression',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'IssueType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRIssueType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'IssueType-list',
        'type' => 'string',
      ),
    ),
    ),
    'IssueSeverity' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRIssueSeverity',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'IssueSeverity-list',
        'type' => 'string',
      ),
    ),
    ),
    'Organization' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIROrganization',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'type' =>
      array (
        'setter' => 'addType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'alias' =>
      array (
        'setter' => 'addAlias',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'address' =>
      array (
        'setter' => 'addAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'partOf' =>
      array (
        'setter' => 'setPartOf',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'Organization.Contact',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIROrganization\\FHIROrganizationContact',
      ),
      'endpoint' =>
      array (
        'setter' => 'addEndpoint',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
    ),
    ),
    'Organization.Contact' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIROrganization\\FHIROrganizationContact',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'purpose' =>
      array (
        'setter' => 'setPurpose',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
    ),
    ),
    'Parameters' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters',
    'extendedElementName' => 'Resource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'parameter' =>
      array (
        'setter' => 'addParameter',
        'element' => 'Parameters.Parameter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters\\FHIRParametersParameter',
      ),
    ),
    ),
    'Parameters.Parameter' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters\\FHIRParametersParameter',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueBase64Binary' =>
      array (
        'setter' => 'setValueBase64Binary',
        'element' => 'base64Binary',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBase64Binary',
      ),
      'valueBoolean' =>
      array (
        'setter' => 'setValueBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'valueCode' =>
      array (
        'setter' => 'setValueCode',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'valueDate' =>
      array (
        'setter' => 'setValueDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'valueDateTime' =>
      array (
        'setter' => 'setValueDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'valueDecimal' =>
      array (
        'setter' => 'setValueDecimal',
        'element' => 'decimal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDecimal',
      ),
      'valueId' =>
      array (
        'setter' => 'setValueId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'valueInstant' =>
      array (
        'setter' => 'setValueInstant',
        'element' => 'instant',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInstant',
      ),
      'valueInteger' =>
      array (
        'setter' => 'setValueInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'valueMarkdown' =>
      array (
        'setter' => 'setValueMarkdown',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'valueOid' =>
      array (
        'setter' => 'setValueOid',
        'element' => 'oid',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIROid',
      ),
      'valuePositiveInt' =>
      array (
        'setter' => 'setValuePositiveInt',
        'element' => 'positiveInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPositiveInt',
      ),
      'valueString' =>
      array (
        'setter' => 'setValueString',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'valueTime' =>
      array (
        'setter' => 'setValueTime',
        'element' => 'time',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTime',
      ),
      'valueUnsignedInt' =>
      array (
        'setter' => 'setValueUnsignedInt',
        'element' => 'unsignedInt',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUnsignedInt',
      ),
      'valueUri' =>
      array (
        'setter' => 'setValueUri',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'valueAddress' =>
      array (
        'setter' => 'setValueAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'valueAge' =>
      array (
        'setter' => 'setValueAge',
        'element' => 'Age',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRAge',
      ),
      'valueAnnotation' =>
      array (
        'setter' => 'setValueAnnotation',
        'element' => 'Annotation',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAnnotation',
      ),
      'valueAttachment' =>
      array (
        'setter' => 'setValueAttachment',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'valueCodeableConcept' =>
      array (
        'setter' => 'setValueCodeableConcept',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'valueCoding' =>
      array (
        'setter' => 'setValueCoding',
        'element' => 'Coding',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCoding',
      ),
      'valueContactPoint' =>
      array (
        'setter' => 'setValueContactPoint',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'valueCount' =>
      array (
        'setter' => 'setValueCount',
        'element' => 'Count',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRCount',
      ),
      'valueDistance' =>
      array (
        'setter' => 'setValueDistance',
        'element' => 'Distance',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDistance',
      ),
      'valueDuration' =>
      array (
        'setter' => 'setValueDuration',
        'element' => 'Duration',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRDuration',
      ),
      'valueHumanName' =>
      array (
        'setter' => 'setValueHumanName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'valueIdentifier' =>
      array (
        'setter' => 'setValueIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'valueMoney' =>
      array (
        'setter' => 'setValueMoney',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'valuePeriod' =>
      array (
        'setter' => 'setValuePeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'valueQuantity' =>
      array (
        'setter' => 'setValueQuantity',
        'element' => 'Quantity',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity',
      ),
      'valueRange' =>
      array (
        'setter' => 'setValueRange',
        'element' => 'Range',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRange',
      ),
      'valueRatio' =>
      array (
        'setter' => 'setValueRatio',
        'element' => 'Ratio',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRRatio',
      ),
      'valueReference' =>
      array (
        'setter' => 'setValueReference',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'valueSampledData' =>
      array (
        'setter' => 'setValueSampledData',
        'element' => 'SampledData',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSampledData',
      ),
      'valueSignature' =>
      array (
        'setter' => 'setValueSignature',
        'element' => 'Signature',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRSignature',
      ),
      'valueTiming' =>
      array (
        'setter' => 'setValueTiming',
        'element' => 'Timing',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRTiming',
      ),
      'valueMeta' =>
      array (
        'setter' => 'setValueMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'resource' =>
      array (
        'setter' => 'setResource',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'part' =>
      array (
        'setter' => 'addPart',
        'element' => 'Parameters.Parameter',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRParameters\\FHIRParametersParameter',
      ),
    ),
    ),
    'Patient' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPatient',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'name' =>
      array (
        'setter' => 'addName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'gender' =>
      array (
        'setter' => 'setGender',
        'element' => 'AdministrativeGender',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdministrativeGender',
      ),
      'birthDate' =>
      array (
        'setter' => 'setBirthDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'deceasedBoolean' =>
      array (
        'setter' => 'setDeceasedBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'deceasedDateTime' =>
      array (
        'setter' => 'setDeceasedDateTime',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'address' =>
      array (
        'setter' => 'addAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'maritalStatus' =>
      array (
        'setter' => 'setMaritalStatus',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'multipleBirthBoolean' =>
      array (
        'setter' => 'setMultipleBirthBoolean',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'multipleBirthInteger' =>
      array (
        'setter' => 'setMultipleBirthInteger',
        'element' => 'integer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRInteger',
      ),
      'photo' =>
      array (
        'setter' => 'addPhoto',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'contact' =>
      array (
        'setter' => 'addContact',
        'element' => 'Patient.Contact',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientContact',
      ),
      'animal' =>
      array (
        'setter' => 'setAnimal',
        'element' => 'Patient.Animal',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientAnimal',
      ),
      'communication' =>
      array (
        'setter' => 'addCommunication',
        'element' => 'Patient.Communication',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientCommunication',
      ),
      'generalPractitioner' =>
      array (
        'setter' => 'addGeneralPractitioner',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'Patient.Link',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientLink',
      ),
    ),
    ),
    'Patient.Contact' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientContact',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'relationship' =>
      array (
        'setter' => 'addRelationship',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'address' =>
      array (
        'setter' => 'setAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'gender' =>
      array (
        'setter' => 'setGender',
        'element' => 'AdministrativeGender',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdministrativeGender',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
    ),
    ),
    'Patient.Animal' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientAnimal',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'species' =>
      array (
        'setter' => 'setSpecies',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'breed' =>
      array (
        'setter' => 'setBreed',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'genderStatus' =>
      array (
        'setter' => 'setGenderStatus',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'Patient.Communication' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientCommunication',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'preferred' =>
      array (
        'setter' => 'setPreferred',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
    ),
    ),
    'Patient.Link' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPatient\\FHIRPatientLink',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'other' =>
      array (
        'setter' => 'setOther',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'LinkType',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRLinkType',
      ),
    ),
    ),
    'LinkType' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRLinkType',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'LinkType-list',
        'type' => 'string',
      ),
    ),
    ),
    'PaymentNotice' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPaymentNotice',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'statusDate' =>
      array (
        'setter' => 'setStatusDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'provider' =>
      array (
        'setter' => 'setProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'paymentStatus' =>
      array (
        'setter' => 'setPaymentStatus',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
    ),
    ),
    'PaymentReconciliation' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPaymentReconciliation',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'FinancialResourceStatusCodes',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRFinancialResourceStatusCodes',
      ),
      'period' =>
      array (
        'setter' => 'setPeriod',
        'element' => 'Period',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPeriod',
      ),
      'created' =>
      array (
        'setter' => 'setCreated',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'organization' =>
      array (
        'setter' => 'setOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'outcome' =>
      array (
        'setter' => 'setOutcome',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'disposition' =>
      array (
        'setter' => 'setDisposition',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'requestProvider' =>
      array (
        'setter' => 'setRequestProvider',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'requestOrganization' =>
      array (
        'setter' => 'setRequestOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'detail' =>
      array (
        'setter' => 'addDetail',
        'element' => 'PaymentReconciliation.Detail',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationDetail',
      ),
      'form' =>
      array (
        'setter' => 'setForm',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'total' =>
      array (
        'setter' => 'setTotal',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
      'processNote' =>
      array (
        'setter' => 'addProcessNote',
        'element' => 'PaymentReconciliation.ProcessNote',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationProcessNote',
      ),
    ),
    ),
    'PaymentReconciliation.Detail' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationDetail',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'request' =>
      array (
        'setter' => 'setRequest',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'response' =>
      array (
        'setter' => 'setResponse',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'submitter' =>
      array (
        'setter' => 'setSubmitter',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'payee' =>
      array (
        'setter' => 'setPayee',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'amount' =>
      array (
        'setter' => 'setAmount',
        'element' => 'Money',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRQuantity\\FHIRMoney',
      ),
    ),
    ),
    'PaymentReconciliation.ProcessNote' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPaymentReconciliation\\FHIRPaymentReconciliationProcessNote',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
    ),
    ),
    'Person' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPerson',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'name' =>
      array (
        'setter' => 'addName',
        'element' => 'HumanName',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRHumanName',
      ),
      'telecom' =>
      array (
        'setter' => 'addTelecom',
        'element' => 'ContactPoint',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRContactPoint',
      ),
      'gender' =>
      array (
        'setter' => 'setGender',
        'element' => 'AdministrativeGender',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAdministrativeGender',
      ),
      'birthDate' =>
      array (
        'setter' => 'setBirthDate',
        'element' => 'date',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDate',
      ),
      'address' =>
      array (
        'setter' => 'addAddress',
        'element' => 'Address',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAddress',
      ),
      'photo' =>
      array (
        'setter' => 'setPhoto',
        'element' => 'Attachment',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRAttachment',
      ),
      'managingOrganization' =>
      array (
        'setter' => 'setManagingOrganization',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'active' =>
      array (
        'setter' => 'setActive',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'link' =>
      array (
        'setter' => 'addLink',
        'element' => 'Person.Link',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResource\\FHIRPerson\\FHIRPersonLink',
      ),
    ),
    ),
    'Person.Link' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRResource\\FHIRPerson\\FHIRPersonLink',
    'extendedElementName' => 'BackboneElement',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'target' =>
      array (
        'setter' => 'setTarget',
        'element' => 'Reference',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRReference',
      ),
      'assurance' =>
      array (
        'setter' => 'setAssurance',
        'element' => 'IdentityAssuranceLevel',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentityAssuranceLevel',
      ),
    ),
    ),
    'IdentityAssuranceLevel' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentityAssuranceLevel',
    'extendedElementName' => 'Element',
    'properties' =>
    array (
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'string-primitive',
        'type' => 'string',
      ),
      'value' =>
      array (
        'setter' => 'setValue',
        'element' => 'IdentityAssuranceLevel-list',
        'type' => 'string',
      ),
    ),
    ),
    'PlanDefinition' =>
    array (
    'fullClassName' => '\\HL7\\FHIR\\STU3\\FHIRDomainResource\\FHIRPlanDefinition',
    'extendedElementName' => 'DomainResource',
    'properties' =>
    array (
      'id' =>
      array (
        'setter' => 'setId',
        'element' => 'id',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRId',
      ),
      'meta' =>
      array (
        'setter' => 'setMeta',
        'element' => 'Meta',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMeta',
      ),
      'implicitRules' =>
      array (
        'setter' => 'setImplicitRules',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'language' =>
      array (
        'setter' => 'setLanguage',
        'element' => 'code',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCode',
      ),
      'text' =>
      array (
        'setter' => 'setText',
        'element' => 'Narrative',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRNarrative',
      ),
      'contained' =>
      array (
        'setter' => 'addContained',
        'element' => 'ResourceContainer',
        'type' => 'HL7\\FHIR\\STU3\\FHIRResourceContainer',
      ),
      'extension' =>
      array (
        'setter' => 'addExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'modifierExtension' =>
      array (
        'setter' => 'addModifierExtension',
        'element' => 'Extension',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRExtension',
      ),
      'url' =>
      array (
        'setter' => 'setUrl',
        'element' => 'uri',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRUri',
      ),
      'identifier' =>
      array (
        'setter' => 'addIdentifier',
        'element' => 'Identifier',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRIdentifier',
      ),
      'version' =>
      array (
        'setter' => 'setVersion',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'name' =>
      array (
        'setter' => 'setName',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'title' =>
      array (
        'setter' => 'setTitle',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'type' =>
      array (
        'setter' => 'setType',
        'element' => 'CodeableConcept',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRCodeableConcept',
      ),
      'status' =>
      array (
        'setter' => 'setStatus',
        'element' => 'PublicationStatus',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRPublicationStatus',
      ),
      'experimental' =>
      array (
        'setter' => 'setExperimental',
        'element' => 'boolean',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRBoolean',
      ),
      'date' =>
      array (
        'setter' => 'setDate',
        'element' => 'dateTime',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRDateTime',
      ),
      'publisher' =>
      array (
        'setter' => 'setPublisher',
        'element' => 'string',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRString',
      ),
      'description' =>
      array (
        'setter' => 'setDescription',
        'element' => 'markdown',
        'type' => 'HL7\\FHIR\\STU3\\FHIRElement\\FHIRMarkdown',
      ),
      'purpose' =>
      array (
   